proc(l)=xlnxdy(x,y) 
; -----------------------------------------------------------------
; Library       glm
; -----------------------------------------------------------------
;  See_also     log xlny
; -----------------------------------------------------------------
;   Macro       xlnxdy
; -----------------------------------------------------------------
;   Description  computes x.*log(x./y), with check for x=y=0,
;                used for GLM macros.                 
; -----------------------------------------------------------------
;   Usage        l = xlnxdy(x,y)
;   Input
;     Parameter   x  
;     Definition        n x k  matrix
;     Parameter   y  
;     Definition        n x k  matrix
;   Output
;     Parameter   l
;     Definition        n x k  matrix
; -----------------------------------------------------------------
;   Example   library("glm")
;             x = 0|2
;             y = 0|1
;             xlnxdy(x,y)
; -----------------------------------------------------------------
;   Result    Contents of l
;             [1,]     0 
;             [2,] 1.3863
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; -----------------------------------------------------------------
  l =     x.*log(x+(x==0)).*(x!=0) - (x==0).*log(1-(x!=0).*(x==0))
  l = l - x.*log(y+(y==0)).*(y!=0) - (y==0).*log(1-(x!=0).*(y==0))
;  l=x.*log( (x./(y+(y==0))).*(x!=0).*(y!=0) + (x==0)+(y==0) )
endp
