proc(l)=xlny(x,y) 
; -----------------------------------------------------------------
; Library       glm
; -----------------------------------------------------------------
;  See_also     log xlnxdy
; -----------------------------------------------------------------
;   Macro       xlny
; -----------------------------------------------------------------
;   Description  computes x.*log(y), with check for x=y=0,
;                used for GLM macros.                 
; -----------------------------------------------------------------
;   Usage        l = xlny(x,y)
;   Input
;     Parameter   x  
;     Definition        n x k  matrix
;     Parameter   y  
;     Definition        n x k  matrix
;   Output
;     Parameter   l
;     Definition        n x k  matrix
; -----------------------------------------------------------------
;   Example   library("glm")
;             x = 0|0|1|1|1
;             y = 0|0.5|1|0|0.5
;             xlny(x,y)
; -----------------------------------------------------------------
;   Result    Contents of l
;             [1,]        0 
;             [2,]        0 
;             [3,]        0 
;             [4,]     -Inf 
;             [5,] -0.69315 
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; -----------------------------------------------------------------
  l = x.*log(y+(y==0)).*(y!=0) + (y==0).*log(1-(x!=0).*(y==0))
endp

