proc (r) = xploretest ()
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      
; -----------------------------------------------------------------
;   Macro        xploretest
; -----------------------------------------------------------------
;   Description  Executes some tests for the macros defined
;                in xplore.lib.
; -----------------------------------------------------------------
;   Usage        xploretest ()
;   Input
;   Output
;     Parameter  r
;     Definition scalar, 0 no error, 1 at least one error
; -----------------------------------------------------------------
;   Example   library("xplore")
;             xploretest()
; -----------------------------------------------------------------
;   Result    Contents of r
;             [1,] 0
; -----------------------------------------------------------------
;   Author    TTK, 960410, Marlene Mueller, 980406
; -----------------------------------------------------------------

  r = 0

; test cov

  randomize (0)
  x = normal (200, 2, 3)
  s = cov (x)
  h = (dim(dim(s)) != 3)
  r = r || h
  error (h , "cov delivers wrong dimension");

  s1 = #(0.93696, 0.02954, 0.02954, 0.93135, 0.82806, 0.011189, 0.011189, 1.1196, 1.0596, 0.13459, 0.13459, 0.99054)

  s1 = reshape (s1, #(2, 2, 3))

  h = sum(abs (#(s-s1)) > 1e-4)

  error (h , "cov seems to calculate wrong");
  r = r || h

; test corr

  randomize (0)
  x = normal (200, 2, 3)
  s = corr (x)
  h = (dim(dim(s)) != 3)
  r = r || h
  error (h , "corr delivers wrong dimension");

  s1 = #(1, 0.031623, 0.031623, 1, 1, 0.011621, 0.011621, 1, 1, 0.13138, 0.13138, 1)
  s1 = reshape (s1, #(2, 2, 3))

  h = sum(abs (#(s-s1)) > 1e-6)

  error (h , "corr seems to calculate wrong");
  r = r || h

; test reduce

  y = reshape (x, #(100, 1, 2, 1, 6));
  y = reduce (y)

  h = dim(y)[1] != 100
  r = r || h
  error (h, "reduce has an error")
  h = dim(y)[2] != 2
  r = r || h
  error (h, "reduce has an error")
  h = dim(y)[3] != 6  
  r = r || h
  error (h, "reduce has an error")

; test quantile

  q = quantile (500:1, #(0:7)/7)
  q1 = #(1, 72, 143, 215, 286, 358, 429, 500)

  h = sum (q != q1)
  r = r || h
  error (h, "quantile has an error")

; test median

  x = reshape( (1:10)~((1:10).*2)~((1:10).*3)~((1:10).*5), 10|2|2)
  m = reshape(5.5~11~16.5~27.5,1|2|2)
  h = 1-prod( abs(vec(median(x)-m)) <1e-6 )

  r = r || h
  error (h, "median has an error")

; test order and rank

  randomize (11)
  x  = normal (100)
  o  = order (x)
  o1 = #(98, 24, 22, 14, 59, 94, 49, 100, 60, 52, 89, 15, 25)

  h = sum (o[1:rows(o1)] != o1)
  r = r || h
  error (h, "order has an error")

  x  = floor(x*10)
  rr = rank (x)
  r1 = #(59, 43.5, 93.5, 15.5, 59, 97.5, 84, 12.5, 15.5, 87.5, 100, 17, 87.5)

  h = sum (rr[1:rows(r1)] != r1)
  r = r || h
  error (h, "rank has an error")

; test kurtosis and skewness

  h = abs (excess(x) - 0.89528) > 1e-5 && abs (skewness(x) + 0.5317) > 1e-5
  r = r || h
  error (h, "error in excess or skewness")

; test aseq and mseq

  h = sum (aseq (1,10,1) != 1:10)
  r = r || h
  error (h, "error in aseq")

  h = sum (mseq (1,5,2)  != (2^(0:4)) )
  r = r || h
  error (h, "error in mseq")

; test round

  x = (-5:5)+uniform(11)/2-0.5
  h = sum (round (x) != -5:5)
  r = r || h
  error (h, "error in round")

; test kron

  h = sum (#(kron(diag(1|1),diag(1:2)) != diag (1|2|1|2)))
  r = r || h
  error (h, "error in kron")

; test xdiag

  x = normal (3)
  h = sum (#(xdiag (diag (x)) != x))
  r = r || h
  error (h, "error in xdiag")

; test stack

  x  = normal (3, 3)
  xx = stack (x, 2*x)
  h  = sum (#(x != xx[,,1] && 2*x != xx[,,2]))
  r  = r || h
  error (h, "error in stack")

; test reduce

  x  = reshape (normal (4, 3), 1|2|1|3|1|2|1)
  h  = sum (dim (reduce (x)) != (2|3|2))
  r  = r || h
  error (h, "error in reduce")

; test gls


  randomize(1964) 
  n = 50 
  x = matrix(n)~normal(n,2) 
  beta = #(10, 2, 3) 
  u = 0.5 * normal(n) 
  y = x*beta .+ u 
  b = gls (x, y) 

  b1 = #(9.97, 1.91157, 3.01233)

  h = abs (((b1'*b)^2)/(b'*b)/(b1'*b1) - 1) > 1e-8
  r  = r || h
  error (h, "error in gls")

; test Inf and NaN

  x = #(0/0, 1/0, -1/0, 1) 
  h = sum (isInf (x) != (0|1|1|0))
  r  = r || h
  error (h, "error in isInf")

  h = sum (isNaN (x) != (1|0|0|0))
  r  = r || h
  error (h, "error in isNaN")

  h = sum (isNumber (x) != (0|0|0|1))
  r  = r || h
  error (h, "error in isNumber")

  h = countNaN (x) != 1
  r  = r || h
  error (h, "error in countNaN")

  h = countNotNumber (x) != 3
  r  = r || h
  error (h, "error in countNotNumber")

;
  x=#(1,3)~#(3,1) 
  {e,v}=eigensm(x)
  h = sum(abs(e-(4|-2)))>1e-4
  r  = r || h
  error (h, "error in eigensm")

;

  mylist=addlist("day",980301,"message","Hi!")
  mylist=addlist(mylist,"question","Did you get it?")
  h  = (mylist.question!="Did you get it?")
  r  = r || h
  error (h, "error in addlist")
  
endp




