proc(yz)=ymulz(ord,di,tb,te,adj,typ,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  zmulz, zxgen
; ----------------------------------------------------------------------
;   Macro	  ymulz
; ----------------------------------------------------------------------
;   Description   auxiliary matrix multiplication for least 
;                 squares regression
; ----------------------------------------------------------------------
;   Usage         yz = ymulz(ord,di,tb,te,adj,typ,ytt)
;   Input 
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   tb 
;     Definition    integer 
;     Parameter   te 
;     Definition    integer
;     Parameter   adj 
;     Definition    integer
;     Parameter   typ 
;     Definition    integer, describing the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;   Output
;     Parameter   yz
;     Definition  matrix
; ----------------------------------------------------------------------
;   Example       library("multi")
;                 ytt=1:3~2:4~3:5
;                 typ=1
;                 ymulz(1,3,3,4,0,typ,ytt)
; ----------------------------------------------------------------------
;   Result        Contents of yz
;                 [1,]        4        9       13       17 
;                 [2,]        6       14       20       26 
;                 [3,]        8       19       27       35 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Sperlich 971024
; ----------------------------------------------------------------------
if (typ==6)
   adj=1
endif
if (ord.>1)
   maxx=floor(8100/(ord*di+1))
else
   maxx=te
endif
yy=ytt-adj*mean(ytt[,tb:te]')'
li1=tb-1
li2=min(te|maxx+tb-1)-1
yz=0
while (li1<te-1) 
   z=zxgen(yy,li1,li2,ord,adj)
   yz=yz+yy[,li1+1:li2+1]*z'
   li1=li2+1
   li2=min(te|maxx+li2)-1
endo
endp
