proc(yz)=yzci(dy,yy,ord,b,e,di) 
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  addfnci, modelci 
; ----------------------------------------------------------------------
;   Macro	  yzci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         yz = yzci(dy,yy,ord,b,e,di)
;   Input 
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   yy 
;     Definition     matrix
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     integer, dimension of time series
;     Parameter   e 
;     Definition     vector 
;     Parameter   di 
;     Definition     vector, dimension of time series 
;   Output
;     Parameter   yz
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ----------------------------------------------------------------------
  if (ord==0)
        yz=0
  else
   if (ord==1)
      yz=sum(yy')'
   else 
   yz=addfnci("fnyzci",ord,dy,di,b,e,yy);
  endif
  endif
endp
