proc(x)=zeros(d1,d2,d3,d4,d5,d6,d7,d8)
; -----------------------------------------------------------------
;   Library       xplore
; -----------------------------------------------------------------
;   See_also      diag xdiag matrix unit eye
; -----------------------------------------------------------------
;   Keywords      matrix
; -----------------------------------------------------------------
;   Macro         zeros
; -----------------------------------------------------------------
;   Description   Creates an array of zeros.
; -----------------------------------------------------------------
;   Usage         x = zeros(d1 {, ..., dn})
;   Input
;     Parameter   d1, ..., dn 
;     Definition      integer (number of elements in dimension 1 ... n) 
;   Output
;     Parameter   x
;     Definition      d1 x d2 x ... x dn array of zeros
; -----------------------------------------------------------------
;   Example   library("xplore")
;             zeros(2,3)
; -----------------------------------------------------------------
;   Result 
;             Contents of x   
;             [1,]   0   0   0 
;             [2,]   0   0   0 
; -----------------------------------------------------------------
;   Author    Christopher Kath  970608; Marlene Mueller, 990308
; -----------------------------------------------------------------
  switch
    case (exist(d2)==0)
      x=matrix(d1)-1
      break
    case (exist(d3)==0)
      x=matrix(d1,d2)-1
      break
    case (exist(d4)==0)
      x=matrix(d1,d2,d3)-1
      break
    case (exist(d5)==0)
      x=matrix(d1,d2,d3,d4)-1
      break
    case (exist(d6)==0)
      x=matrix(d1,d2,d3,d4,d5)-1
      break
    case (exist(d7)==0)
      x=matrix(d1,d2,d3,d4,d5,d6)-1
      break
    case (exist(d8)==0)
      x=matrix(d1,d2,d3,d4,d5,d6,d7)-1
      break
    default
      x=matrix(d1,d2,d3,d4,d5,d6,d7,d8)-1
      break
  endsw
endp



