proc(z)=zgenci(dy,ord,b,e,di);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  zzgenci 
; ----------------------------------------------------------------------
;   Macro	  zgenci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         z=zgenci(dy,ord,b,e,di)
;   Input 
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     matrix 
;     Parameter   e 
;     Definition     vector 
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   z
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
  if (ord==0)
    z=0
  else
    t=e-b+1
    z=ones(1,t)
    if (ord >=2)
      x=shiftr(kron(ones(ord-1,1),dy[,b-ord+1:e]), kron(aseq(1,ord-1,1),ones(di,1)), 0);
      z=z | x[,ord:cols(x)];
    endif;
  endif;
endp;
