proc(zz)=zmulz(ord,di,tb,te,adj,opt,typ,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  ymulz, zxgen
; ----------------------------------------------------------------------
;   Macro	  zmulz
; ----------------------------------------------------------------------
;   Description   auxiliary matrix multiplication for least 
;                 squares regression
; ----------------------------------------------------------------------
;   Usage         zz = zmulz(ord,di,tb,te,adj,opt,typ,ytt)
;   Input 
;     Parameter   ord 
;     Definition     integer, order of series
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   tb 
;     Definition     integer 
;     Parameter   te 
;     Definition     integer
;     Parameter   adj 
;     Definition     scalar
;     Parameter   opt 
;     Definition     integer
;     Parameter   typ 
;     Definition     integer, describing the model type
;     Parameter   ytt
;     Definition     vector, the transformed time series
;   Output
;     Parameter   zz
;     Definition     matrix
; ----------------------------------------------------------------------
;   Example       library("multi")
;                 ytt=1:3~2:4~3:5
;                 typ=1
;                 zmulz(1,3,3,4,0,0,typ,ytt)
; ----------------------------------------------------------------------
;   Result       Contents of zz
;                [1,]        2        5        7        9 
;                [2,]        5       13       18       23 
;                [3,]        7       18       25       32 
;                [4,]        9       23       32       41 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Sperlich 971024
; ----------------------------------------------------------------------
if (typ==6)
   adj=1
endif
if (ord.>1)
   maxx=floor(8100/(ord*di+1))
else
   maxx=te
endif
yy=ytt-adj*mean(ytt[,tb+opt:te+opt]')'
li1=tb-1
li2=min(te|maxx+tb-1)-1
zz=0
while (li1<te-1)  
   z=zxgen(yy,li1,li2,ord,adj)
   zz=zz+z*z'
   li1=li2+1
   li2=min(te|maxx+li2)-1
endo

endp
