proc(wr, wi, zr, zi)=cg(ar, ai)
; -----------------------------------------------------------------------
; Library				math
; -----------------------------------------------------------------------
;	Macro					cg
; -----------------------------------------------------------------------
; Description		Computes the eigenvalues and eigenvectors of a complex
;								general matrix							
; -----------------------------------------------------------------------
;	Notes					the matrix is given by ar and ai with ar the real and ai						ai = yi1~yi2~...~yin with ar the real part and ai the 
;								the imaginary part
; -----------------------------------------------------------------------
;	Keywords			eigen values, eigen vectors, complex general matrix
; -----------------------------------------------------------------------
;	Usage					{wr, wi, zr, zi} = cg(ar{, ai})
;	Input					
;		Parameter		ar
;		Definition	n x m matrix
;		Parameter		ai
;		Definition	n x m matrix
;	Output				
;		Parameter		wr
;		Definition	n x 1 vector of real eigenvalues
;		Parameter		wi
;		Definition	n x 1 vector of imaginary eigenvalues
;   Parameter		zr
;		Definition	n x m matrix of real eigenvectors
;   Parameter		zi
;		Definition	m x m matrix of imaginary eigenvectors
; -----------------------------------------------------------------------
;	Example				library("math")
;								ar = #(3, 1)~#(-10, 9)
;								ai = #(2, 1)~#(1, 1)
;								wr = rows(ar)
;								wi = rows(ai)
;								zr = ar.*0
;								zi = ai.*0
;								{wr, wi, zr, zi} = cg(ar, ai)
;								wr
;								wi
;								zr
;								zi
; -----------------------------------------------------------------------
;	Result				 Contents of wr

;

;								[1,]   3.7685 
;								[2,]   8.2315 
;								 Contents of wi

;	

;								[1,]   4.1888 
;								[2,]  -1.1888 
;								 Contents of zr

;

;								[1,]  -5.2597 -0.75934 
;								[2,] -0.06684  0.083265 
;								 Contents of zi

;

;								[1,]  -1.5739   1.2656 
;								[2,]   1.2655  -0.8959 
; -----------------------------------------------------------------------
;	Author				Fabian Noetzel
; -----------------------------------------------------------------------
  
  h = dlopen("d:\eispack\c\eispack.dll")
  
  if (exist(ai)!=1)
    ai=0.*matrix(rows(ar), cols(ar))  
  endif
  
  error (rows(ar)!=rows(ai), "cg: rows(ar) <> rows(ai)")
  
  error (cols(ar)!=cols(ai), "cg: cols(ar) <> cols(ai)")
  
  wr = matrix(rows(ar))					 
  wi = matrix(rows(ai))
  zr = ar.*0							 
  zi = ai.*0							 							
  
  nm = rows(ar) 
  n = cols(ar)
  matz=1
  
  param = list(nm, n, ar, ai, wr, wi, matz, zr, zi)
  byrow = 0|0|0|0|0|0|0|0|0
  type = -8|-8|8|8|8|8|-4|8|8
  opt = list(type, byrow)
  
  err = dlcallex(h, "_cg", param, opt)
  
  error(err==10101, "cg: Number of arguments given is wrong") 
  error(err==10201, "cg: First argument has wrong type")	
  error(err==10202, "cg: Second argument has wrong type")	
  error(err==10203, "cg: Third argument has wrong type")	
  error(err==10204, "cg: Fourth argument has wrong type")	
  error(err==10205, "cg: Fifth argument has wrong type")	
  error(err==10206, "cg: Sixth argument has wrong type")
  error(err==10207, "cg: Fourth argument has wrong type")	
  error(err==10208, "cg: Fifth argument has wrong type")	
  error(err==10209, "cg: Sixth argument has wrong type")	
  error(err==10300, "cg: Squared matrix expected")
  error(err==10400, "cg: Symmetric matrix expected")
  error(err==10500, "cg: Not enough memory")
  
  wr=param.wr
  wi=param.wi
  zr=param.zr
  zi=param.zi
  
  dlclose(h)
  
endp