/* invit.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int invit_(nm, n, a, wr, wi, select, mm, m, z, ierr, rm1, 
	rv1, rv2)
integer *nm, *n;
doublereal *a, *wr, *wi;
logical *select;
integer *mm, *m;
doublereal *z;
integer *ierr;
doublereal *rm1, *rv1, *rv2;
{
    /* System generated locals */
    integer a_dim1, a_offset, z_dim1, z_offset, rm1_dim1, rm1_offset, i__1, 
	    i__2, i__3;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    extern /* Subroutine */ int cdiv_();
    static doublereal norm;
    static integer i, j, k, l, s;
    static doublereal t, w, x, y;
    static integer n1;
    static doublereal normv;
    static integer ii;
    static doublereal ilambd;
    static integer ip, mp, ns, uk;
    static doublereal rlambd;
    extern doublereal pythag_(), epslon_();
    static integer km1, ip1;
    static doublereal growto, ukroot;
    static integer its;
    static doublereal eps3;



/*     this subroutine is a translation of the algol procedure invit */
/*     by peters and wilkinson. */
/*     handbook for auto. comp., vol.ii-linear algebra, 418-439(1971). */

/*     this subroutine finds those eigenvectors of a real upper */
/*     hessenberg matrix corresponding to specified eigenvalues, */
/*     using inverse iteration. */

/*     on input */

/*        nm must be set to the row dimension of two-dimensional */
/*          array parameters as declared in the calling program */
/*          dimension statement. */

/*        n is the order of the matrix. */

/*        a contains the hessenberg matrix. */

/*        wr and wi contain the real and imaginary parts, respectively, */
/*          of the eigenvalues of the matrix.  the eigenvalues must be */
/*          stored in a manner identical to that of subroutine  hqr, */
/*          which recognizes possible splitting of the matrix. */

/*        select specifies the eigenvectors to be found. the */
/*          eigenvector corresponding to the j-th eigenvalue is */
/*          specified by setting select(j) to .true.. */

/*        mm should be set to an upper bound for the number of */
/*          columns required to store the eigenvectors to be found. */
/*          note that two columns are required to store the */
/*          eigenvector corresponding to a complex eigenvalue. */

/*     on output */

/*        a and wi are unaltered. */

/*        wr may have been altered since close eigenvalues are perturbed 
*/
/*          slightly in searching for independent eigenvectors. */

/*        select may have been altered.  if the elements corresponding */
/*          to a pair of conjugate complex eigenvalues were each */
/*          initially set to .true., the program resets the second of */
/*          the two elements to .false.. */

/*        m is the number of columns actually used to store */
/*          the eigenvectors. */

/*        z contains the real and imaginary parts of the eigenvectors. */
/*          if the next selected eigenvalue is real, the next column */
/*          of z contains its eigenvector.  if the eigenvalue is */
/*          complex, the next two columns of z contain the real and */
/*          imaginary parts of its eigenvector.  the eigenvectors are */
/*          normalized so that the component of largest magnitude is 1. */
/*          any vector which fails the acceptance test is set to zero. */

/*        ierr is set to */
/*          zero       for normal return, */
/*          -(2*n+1)   if more than mm columns of z are necessary */
/*                     to store the eigenvectors corresponding to */
/*                     the specified eigenvalues. */
/*          -k         if the iteration corresponding to the k-th */
/*                     value fails, */
/*          -(n+k)     if both error situations occur. */

/*        rm1, rv1, and rv2 are temporary storage arrays.  note that rm1 
*/
/*          is square of dimension n by n and, augmented by two columns */
/*          of z, is the transpose of the corresponding algol b array. */

/*     the algol procedure guessvec appears in invit in line. */

/*     calls cdiv for complex division. */
/*     calls pythag for  dsqrt(a*a + b*b) . */

/*     questions and comments should be directed to burton s. garbow, */
/*     mathematics and computer science div, argonne national laboratory 
*/

/*     this version dated august 1983. */

/*     ------------------------------------------------------------------ 
*/

    /* Parameter adjustments */
    --rv2;
    --rv1;
    rm1_dim1 = *n;
    rm1_offset = rm1_dim1 + 1;
    rm1 -= rm1_offset;
    --select;
    --wi;
    --wr;
    a_dim1 = *nm;
    a_offset = a_dim1 + 1;
    a -= a_offset;
    z_dim1 = *nm;
    z_offset = z_dim1 + 1;
    z -= z_offset;

    /* Function Body */
    *ierr = 0;
    uk = 0;
    s = 1;
/*     .......... ip = 0, real eigenvalue */
/*                     1, first of conjugate complex pair */
/*                    -1, second of conjugate complex pair .......... */
    ip = 0;
    n1 = *n - 1;

    i__1 = *n;
    for (k = 1; k <= i__1; ++k) {
	if (wi[k] == 0. || ip < 0) {
	    goto L100;
	}
	ip = 1;
	if (select[k] && select[k + 1]) {
	    select[k + 1] = FALSE_;
	}
L100:
	if (! select[k]) {
	    goto L960;
	}
	if (wi[k] != 0.) {
	    ++s;
	}
	if (s > *mm) {
	    goto L1000;
	}
	if (uk >= k) {
	    goto L200;
	}
/*     .......... check for possible splitting .......... */
	i__2 = *n;
	for (uk = k; uk <= i__2; ++uk) {
	    if (uk == *n) {
		goto L140;
	    }
	    if (a[uk + 1 + uk * a_dim1] == 0.) {
		goto L140;
	    }
/* L120: */
	}
/*     .......... compute infinity norm of leading uk by uk */
/*                (hessenberg) matrix .......... */
L140:
	norm = 0.;
	mp = 1;

	i__2 = uk;
	for (i = 1; i <= i__2; ++i) {
	    x = 0.;

	    i__3 = uk;
	    for (j = mp; j <= i__3; ++j) {
/* L160: */
		x += (d__1 = a[i + j * a_dim1], abs(d__1));
	    }

	    if (x > norm) {
		norm = x;
	    }
	    mp = i;
/* L180: */
	}
/*     .......... eps3 replaces zero pivot in decomposition */
/*                and close roots are modified by eps3 .......... */
	if (norm == 0.) {
	    norm = 1.;
	}
	eps3 = epslon_(&norm);
/*     .......... growto is the criterion for the growth .......... */
	ukroot = (doublereal) uk;
	ukroot = sqrt(ukroot);
	growto = .1 / ukroot;
L200:
	rlambd = wr[k];
	ilambd = wi[k];
	if (k == 1) {
	    goto L280;
	}
	km1 = k - 1;
	goto L240;
/*     .......... perturb eigenvalue if it is close */
/*                to any previous eigenvalue .......... */
L220:
	rlambd += eps3;
/*     .......... for i=k-1 step -1 until 1 do -- .......... */
L240:
	i__2 = km1;
	for (ii = 1; ii <= i__2; ++ii) {
	    i = k - ii;
	    if (select[i] && (d__1 = wr[i] - rlambd, abs(d__1)) < eps3 && (
		    d__2 = wi[i] - ilambd, abs(d__2)) < eps3) {
		goto L220;
	    }
/* L260: */
	}

	wr[k] = rlambd;
/*     .......... perturb conjugate eigenvalue to match .......... */
	ip1 = k + ip;
	wr[ip1] = rlambd;
/*     .......... form upper hessenberg a-rlambd*i (transposed) */
/*                and initial real vector .......... */
L280:
	mp = 1;

	i__2 = uk;
	for (i = 1; i <= i__2; ++i) {

	    i__3 = uk;
	    for (j = mp; j <= i__3; ++j) {
/* L300: */
		rm1[j + i * rm1_dim1] = a[i + j * a_dim1];
	    }

	    rm1[i + i * rm1_dim1] -= rlambd;
	    mp = i;
	    rv1[i] = eps3;
/* L320: */
	}

	its = 0;
	if (ilambd != 0.) {
	    goto L520;
	}
/*     .......... real eigenvalue. */
/*                triangular decomposition with interchanges, */
/*                replacing zero pivots by eps3 .......... */
	if (uk == 1) {
	    goto L420;
	}

	i__2 = uk;
	for (i = 2; i <= i__2; ++i) {
	    mp = i - 1;
	    if ((d__1 = rm1[mp + i * rm1_dim1], abs(d__1)) <= (d__2 = rm1[mp 
		    + mp * rm1_dim1], abs(d__2))) {
		goto L360;
	    }

	    i__3 = uk;
	    for (j = mp; j <= i__3; ++j) {
		y = rm1[j + i * rm1_dim1];
		rm1[j + i * rm1_dim1] = rm1[j + mp * rm1_dim1];
		rm1[j + mp * rm1_dim1] = y;
/* L340: */
	    }

L360:
	    if (rm1[mp + mp * rm1_dim1] == 0.) {
		rm1[mp + mp * rm1_dim1] = eps3;
	    }
	    x = rm1[mp + i * rm1_dim1] / rm1[mp + mp * rm1_dim1];
	    if (x == 0.) {
		goto L400;
	    }

	    i__3 = uk;
	    for (j = i; j <= i__3; ++j) {
/* L380: */
		rm1[j + i * rm1_dim1] -= x * rm1[j + mp * rm1_dim1];
	    }

L400:
	    ;
	}

L420:
	if (rm1[uk + uk * rm1_dim1] == 0.) {
	    rm1[uk + uk * rm1_dim1] = eps3;
	}
/*     .......... back substitution for real vector */
/*                for i=uk step -1 until 1 do -- .......... */
L440:
	i__2 = uk;
	for (ii = 1; ii <= i__2; ++ii) {
	    i = uk + 1 - ii;
	    y = rv1[i];
	    if (i == uk) {
		goto L480;
	    }
	    ip1 = i + 1;

	    i__3 = uk;
	    for (j = ip1; j <= i__3; ++j) {
/* L460: */
		y -= rm1[j + i * rm1_dim1] * rv1[j];
	    }

L480:
	    rv1[i] = y / rm1[i + i * rm1_dim1];
/* L500: */
	}

	goto L740;
/*     .......... complex eigenvalue. */
/*                triangular decomposition with interchanges, */
/*                replacing zero pivots by eps3.  store imaginary */
/*                parts in upper triangle starting at (1,3) ..........
 */
L520:
	ns = *n - s;
	z[(s - 1) * z_dim1 + 1] = -ilambd;
	z[s * z_dim1 + 1] = 0.;
	if (*n == 2) {
	    goto L550;
	}
	rm1[rm1_dim1 * 3 + 1] = -ilambd;
	z[(s - 1) * z_dim1 + 1] = 0.;
	if (*n == 3) {
	    goto L550;
	}

	i__2 = *n;
	for (i = 4; i <= i__2; ++i) {
/* L540: */
	    rm1[i * rm1_dim1 + 1] = 0.;
	}

L550:
	i__2 = uk;
	for (i = 2; i <= i__2; ++i) {
	    mp = i - 1;
	    w = rm1[mp + i * rm1_dim1];
	    if (i < *n) {
		t = rm1[mp + (i + 1) * rm1_dim1];
	    }
	    if (i == *n) {
		t = z[mp + (s - 1) * z_dim1];
	    }
	    x = rm1[mp + mp * rm1_dim1] * rm1[mp + mp * rm1_dim1] + t * t;
	    if (w * w <= x) {
		goto L580;
	    }
	    x = rm1[mp + mp * rm1_dim1] / w;
	    y = t / w;
	    rm1[mp + mp * rm1_dim1] = w;
	    if (i < *n) {
		rm1[mp + (i + 1) * rm1_dim1] = 0.;
	    }
	    if (i == *n) {
		z[mp + (s - 1) * z_dim1] = 0.;
	    }

	    i__3 = uk;
	    for (j = i; j <= i__3; ++j) {
		w = rm1[j + i * rm1_dim1];
		rm1[j + i * rm1_dim1] = rm1[j + mp * rm1_dim1] - x * w;
		rm1[j + mp * rm1_dim1] = w;
		if (j < n1) {
		    goto L555;
		}
		l = j - ns;
		z[i + l * z_dim1] = z[mp + l * z_dim1] - y * w;
		z[mp + l * z_dim1] = 0.;
		goto L560;
L555:
		rm1[i + (j + 2) * rm1_dim1] = rm1[mp + (j + 2) * rm1_dim1] - 
			y * w;
		rm1[mp + (j + 2) * rm1_dim1] = 0.;
L560:
		;
	    }

	    rm1[i + i * rm1_dim1] -= y * ilambd;
	    if (i < n1) {
		goto L570;
	    }
	    l = i - ns;
	    z[mp + l * z_dim1] = -ilambd;
	    z[i + l * z_dim1] += x * ilambd;
	    goto L640;
L570:
	    rm1[mp + (i + 2) * rm1_dim1] = -ilambd;
	    rm1[i + (i + 2) * rm1_dim1] += x * ilambd;
	    goto L640;
L580:
	    if (x != 0.) {
		goto L600;
	    }
	    rm1[mp + mp * rm1_dim1] = eps3;
	    if (i < *n) {
		rm1[mp + (i + 1) * rm1_dim1] = 0.;
	    }
	    if (i == *n) {
		z[mp + (s - 1) * z_dim1] = 0.;
	    }
	    t = 0.;
	    x = eps3 * eps3;
L600:
	    w /= x;
	    x = rm1[mp + mp * rm1_dim1] * w;
	    y = -t * w;

	    i__3 = uk;
	    for (j = i; j <= i__3; ++j) {
		if (j < n1) {
		    goto L610;
		}
		l = j - ns;
		t = z[mp + l * z_dim1];
		z[i + l * z_dim1] = -x * t - y * rm1[j + mp * rm1_dim1];
		goto L615;
L610:
		t = rm1[mp + (j + 2) * rm1_dim1];
		rm1[i + (j + 2) * rm1_dim1] = -x * t - y * rm1[j + mp * 
			rm1_dim1];
L615:
		rm1[j + i * rm1_dim1] = rm1[j + i * rm1_dim1] - x * rm1[j + 
			mp * rm1_dim1] + y * t;
/* L620: */
	    }

	    if (i < n1) {
		goto L630;
	    }
	    l = i - ns;
	    z[i + l * z_dim1] -= ilambd;
	    goto L640;
L630:
	    rm1[i + (i + 2) * rm1_dim1] -= ilambd;
L640:
	    ;
	}

	if (uk < n1) {
	    goto L650;
	}
	l = uk - ns;
	t = z[uk + l * z_dim1];
	goto L655;
L650:
	t = rm1[uk + (uk + 2) * rm1_dim1];
L655:
	if (rm1[uk + uk * rm1_dim1] == 0. && t == 0.) {
	    rm1[uk + uk * rm1_dim1] = eps3;
	}
/*     .......... back substitution for complex vector */
/*                for i=uk step -1 until 1 do -- .......... */
L660:
	i__2 = uk;
	for (ii = 1; ii <= i__2; ++ii) {
	    i = uk + 1 - ii;
	    x = rv1[i];
	    y = 0.;
	    if (i == uk) {
		goto L700;
	    }
	    ip1 = i + 1;

	    i__3 = uk;
	    for (j = ip1; j <= i__3; ++j) {
		if (j < n1) {
		    goto L670;
		}
		l = j - ns;
		t = z[i + l * z_dim1];
		goto L675;
L670:
		t = rm1[i + (j + 2) * rm1_dim1];
L675:
		x = x - rm1[j + i * rm1_dim1] * rv1[j] + t * rv2[j];
		y = y - rm1[j + i * rm1_dim1] * rv2[j] - t * rv1[j];
/* L680: */
	    }

L700:
	    if (i < n1) {
		goto L710;
	    }
	    l = i - ns;
	    t = z[i + l * z_dim1];
	    goto L715;
L710:
	    t = rm1[i + (i + 2) * rm1_dim1];
L715:
	    cdiv_(&x, &y, &rm1[i + i * rm1_dim1], &t, &rv1[i], &rv2[i]);
/* L720: */
	}
/*     .......... acceptance test for real or complex */
/*                eigenvector and normalization .......... */
L740:
	++its;
	norm = 0.;
	normv = 0.;

	i__2 = uk;
	for (i = 1; i <= i__2; ++i) {
	    if (ilambd == 0.) {
		x = (d__1 = rv1[i], abs(d__1));
	    }
	    if (ilambd != 0.) {
		x = pythag_(&rv1[i], &rv2[i]);
	    }
	    if (normv >= x) {
		goto L760;
	    }
	    normv = x;
	    j = i;
L760:
	    norm += x;
/* L780: */
	}

	if (norm < growto) {
	    goto L840;
	}
/*     .......... accept vector .......... */
	x = rv1[j];
	if (ilambd == 0.) {
	    x = 1. / x;
	}
	if (ilambd != 0.) {
	    y = rv2[j];
	}

	i__2 = uk;
	for (i = 1; i <= i__2; ++i) {
	    if (ilambd != 0.) {
		goto L800;
	    }
	    z[i + s * z_dim1] = rv1[i] * x;
	    goto L820;
L800:
	    cdiv_(&rv1[i], &rv2[i], &x, &y, &z[i + (s - 1) * z_dim1], &z[i + 
		    s * z_dim1]);
L820:
	    ;
	}

	if (uk == *n) {
	    goto L940;
	}
	j = uk + 1;
	goto L900;
/*     .......... in-line procedure for choosing */
/*                a new starting vector .......... */
L840:
	if (its >= uk) {
	    goto L880;
	}
	x = ukroot;
	y = eps3 / (x + 1.);
	rv1[1] = eps3;

	i__2 = uk;
	for (i = 2; i <= i__2; ++i) {
/* L860: */
	    rv1[i] = y;
	}

	j = uk - its + 1;
	rv1[j] -= eps3 * x;
	if (ilambd == 0.) {
	    goto L440;
	}
	goto L660;
/*     .......... set error -- unaccepted eigenvector .......... */
L880:
	j = 1;
	*ierr = -k;
/*     .......... set remaining vector components to zero .......... 
*/
L900:
	i__2 = *n;
	for (i = j; i <= i__2; ++i) {
	    z[i + s * z_dim1] = 0.;
	    if (ilambd != 0.) {
		z[i + (s - 1) * z_dim1] = 0.;
	    }
/* L920: */
	}

L940:
	++s;
L960:
	if (ip == -1) {
	    ip = 0;
	}
	if (ip == 1) {
	    ip = -1;
	}
/* L980: */
    }

    goto L1001;
/*     .......... set error -- underestimate of eigenvector */
/*                space required .......... */
L1000:
    if (*ierr != 0) {
	*ierr -= *n;
    }
    if (*ierr == 0) {
	*ierr = -((*n << 1) + 1);
    }
L1001:
    *m = s - 1 - abs(ip);
    return 0;
} /* invit_ */

