/* ortbak.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int ortbak_(nm, low, igh, a, ort, m, z)
integer *nm, *low, *igh;
doublereal *a, *ort;
integer *m;
doublereal *z;
{
    /* System generated locals */
    integer a_dim1, a_offset, z_dim1, z_offset, i__1, i__2, i__3;

    /* Local variables */
    static doublereal g;
    static integer i, j, la, mm, mp, kp1, mp1;



/*     this subroutine is a translation of the algol procedure ortbak, */
/*     num. math. 12, 349-368(1968) by martin and wilkinson. */
/*     handbook for auto. comp., vol.ii-linear algebra, 339-358(1971). */

/*     this subroutine forms the eigenvectors of a real general */
/*     matrix by back transforming those of the corresponding */
/*     upper hessenberg matrix determined by  orthes. */

/*     on input */

/*        nm must be set to the row dimension of two-dimensional */
/*          array parameters as declared in the calling program */
/*          dimension statement. */

/*        low and igh are integers determined by the balancing */
/*          subroutine  balanc.  if  balanc  has not been used, */
/*          set low=1 and igh equal to the order of the matrix. */

/*        a contains information about the orthogonal trans- */
/*          formations used in the reduction by  orthes */
/*          in its strict lower triangle. */

/*        ort contains further information about the trans- */
/*          formations used in the reduction by  orthes. */
/*          only elements low through igh are used. */

/*        m is the number of columns of z to be back transformed. */

/*        z contains the real and imaginary parts of the eigen- */
/*          vectors to be back transformed in its first m columns. */

/*     on output */

/*        z contains the real and imaginary parts of the */
/*          transformed eigenvectors in its first m columns. */

/*        ort has been altered. */

/*     note that ortbak preserves vector euclidean norms. */

/*     questions and comments should be directed to burton s. garbow, */
/*     mathematics and computer science div, argonne national laboratory 
*/

/*     this version dated august 1983. */

/*     ------------------------------------------------------------------ 
*/

    /* Parameter adjustments */
    --ort;
    a_dim1 = *nm;
    a_offset = a_dim1 + 1;
    a -= a_offset;
    z_dim1 = *nm;
    z_offset = z_dim1 + 1;
    z -= z_offset;

    /* Function Body */
    if (*m == 0) {
	goto L200;
    }
    la = *igh - 1;
    kp1 = *low + 1;
    if (la < kp1) {
	goto L200;
    }
/*     .......... for mp=igh-1 step -1 until low+1 do -- .......... */
    i__1 = la;
    for (mm = kp1; mm <= i__1; ++mm) {
	mp = *low + *igh - mm;
	if (a[mp + (mp - 1) * a_dim1] == 0.) {
	    goto L140;
	}
	mp1 = mp + 1;

	i__2 = *igh;
	for (i = mp1; i <= i__2; ++i) {
/* L100: */
	    ort[i] = a[i + (mp - 1) * a_dim1];
	}

	i__2 = *m;
	for (j = 1; j <= i__2; ++j) {
	    g = 0.;

	    i__3 = *igh;
	    for (i = mp; i <= i__3; ++i) {
/* L110: */
		g += ort[i] * z[i + j * z_dim1];
	    }
/*     .......... divisor below is negative of h formed in orthes.
 */
/*                double division avoids possible underflow ......
.... */
	    g = g / ort[mp] / a[mp + (mp - 1) * a_dim1];

	    i__3 = *igh;
	    for (i = mp; i <= i__3; ++i) {
/* L120: */
		z[i + j * z_dim1] += g * ort[i];
	    }

/* L130: */
	}

L140:
	;
    }

L200:
    return 0;
} /* ortbak_ */

