proc(w,z)=rs(a)
; -----------------------------------------------------------------------
; Library				math
; -----------------------------------------------------------------------
;	Macro					rs
; -----------------------------------------------------------------------
; Description		Computes the eigenvalues and eigenvectors of a real
;								symmetric square matrix							
; -----------------------------------------------------------------------
;	Keywords			eigen values, eigen vectors, real symmetric square matrix
; -----------------------------------------------------------------------
;	Usage					{w, z} = rs(a)
;	Input					
;		Parameter		a
;		Definition	n x n matrix
;	Output				
;		Parameter		w
;		Definition	n x 1 vector of eigenvalues
;   Parameter		z
;		Definition	n x n matrix of eigenvectors
; -----------------------------------------------------------------------
;	Example				library("math")
;								y1 = #(1, -1, 0)
;								y2 = #(-1, 2, -1)
;								y3 = #(0, -1, 1)
;								a = y1~y2~y3
;								{w, z} = rs(a)
;								w
;								z
; -----------------------------------------------------------------------
; Result 				Contents of w
;
;								[1,] -2.5653e-16 
;								[2,]        1 
;								[3,]        3 
;								Contents of z
;
;								[1,]  0.57735  0.70711  0.40825 
;								[2,]  0.57735 -2.8623e-16  -0.8165 
;								[3,]  0.57735 -0.70711  0.40825 
;
; -----------------------------------------------------------------------
;	Author				Fabian Noetzel
; -----------------------------------------------------------------------
  
  h = dlopen("eispack.dll")
  
  w = matrix(rows(a))					 
  z = a.*0							 
  matz = 1							
  nm = rows(a)
  n = cols(a)
  
  param = list(nm, n, a, w, matz, z)
  byrow = 0|0|0|0|0|0
  type = -8|-8|8|8|-4|8
  opt = list(type, byrow)
  
  err = dlcallex(h, "_rs", param, opt)
  
  error(err==10101, "rs: Number of arguments given is wrong") 
  error(err==10201, "rs: First argument has wrong type")	
  error(err==10202, "rs: Second argument has wrong type")	
  error(err==10203, "rs: Third argument has wrong type")	
  error(err==10204, "rs: Fourth argument has wrong type")	
  error(err==10205, "rs: Fifth argument has wrong type")	
  error(err==10206, "rs: Sixth argument has wrong type")	
  error(err==10300, "rs: Squared matrix expected")
  error(err==10400, "rs: Symmetric matrix expected")
  error(err==10500, "rs: Not enough memory")
  
  w=param.w
  z=param.z
  
  dlclose(h)
  
endp