; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      hazcoxb
; ----------------------------------------------------------------------------
; Macro         haz07
; ----------------------------------------------------------------------------
; Description   estimates and plots the cumulative baseline hazard and 
;		baseline survival functions for simulated data
; ----------------------------------------------------------------------------
 library("hazreg") 
 dat=read("haz01.dat")  
 t = dat[,1]                            ; observed times                      
 delta = dat[,2]                        ; censoring indicator                       
 z = dat[,3:4]                          ; covariates     
 {data,ties} = hazdat(t,delta, z)       ; preparing data
 {bcumhaz,bsurv} = hazcoxb(data)        ; compute estimates

 setsize(600,400)                       ; initiating graph
 plot1=createdisplay(1,1)               ; initiating graph
 plot2=createdisplay(1,1)
 n = rows(data)                         ; sample size
 pm = (#(1,n+2)'+ (0:n))|(#(2*n+2,3*n+3)'+ (0:n))
                                        ; points to be connected
 cn = matrix(2*n+2)                     ; color_num, controls colors
 ar = matrix(2*n+2)                     ; art, controls line types
 th = matrix(2*n+2)                     ; thick, controls line thickness 

 bsurvline = steps4plot(bsurv, 0~1)     ; points for step function plot
 setmaskl(bsurvline, pm, cn, ar, th)    ; lines connected
 setmaskp(bsurvline, 4, 0, 8)           ; points controlled

 bcumhazline = steps4plot(bcumhaz, 0~0) ; points for step function plot
 setmaskl(bcumhazline, pm, cn, ar, th)
 setmaskp(bcumhazline, 4, 0, 8)

 show(plot1, 1, 1, bcumhazline)      	; plot baseline hazard
 setgopt(plot1, 1, 1, "title","Cumulative Baseline Hazard")
 setgopt(plot1, 1, 1, "xlabel","Time","ylabel","Cumulative Hazard")
 setgopt(plot1, 1, 1, "ymajor", 0.5)
 print (plot1,"hazbcumhaztest.ps")   
          
 show(plot2,1, 1, bsurvline)            ; plot baseline survival
 setgopt(plot2, 1, 1, "title","Baseline Survival Function")
 setgopt(plot2, 1, 1, "xlabel","Time","ylabel","Survival  Function")
 setgopt(plot2, 1, 1,  "ymajor", 0.2, "ylim", (0|1.01))
; uncomment the following line for a PS picture
; print (plot2,"hazbsurvtest.ps")             

