; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         ls02
; ----------------------------------------------------------------------------
; Description   estimation of an artificial data set by OLS
;               with graphical output and residual plot
; ----------------------------------------------------------------------------
proc() = myquant(obs1, beta)
  ;
  ; initialization
  ;
  n = 10                   ; number of observations
  randomize(17654321)      ; sets random seed
  x = matrix(n)~uniform(n)
  ;                        ; creates design matrix   
  ;
  ; new x-observation is added
  ;
  x = x|(1~obs1[1])
  m = x*beta               ; defines regression line
  eps = 0.05*normal(n)     ; creates obs error
  ;
  ; new y-observation is added
  ;
  y = m[1:n] + eps         ; noisy line
  y = y|obs1[2]
  ;
  ; create graphical display and draw data points
  ;
  d = createdisplay(1,2)     
  dat = x[,2]~y                              
  outl = obs1[1]~obs1[2]
  setmaskp(outl,1,12,15)    ; outlier is blue big star
  tdat = x[,2]~m
  setmaskl(tdat, (1:rows(tdat))', 1, 1, 1) 
  ;                        ; thin blue line
  setmaskp(tdat, 0, 0, 0)  ; reduces point size to min
  ;
  ; estimation of the model using rqfit 
  ;
  beta1 = gls(x,y)
  ;
  ; draw estimated regression line
  ;
  yhat = x*beta1
  hdat = x[,2]~yhat
  setmaskp(hdat, 0, 0, 0)    
  setmaskl(hdat, (1:rows(hdat))', 4, 1, 3)
  ;                        ; thick red line
  show(d, 1, 1, dat[1:n], outl, tdat, hdat)
  title="Least squares regression with an outlier"
  setgopt(d,1,1,"title",title) 
  ;                        ; sets title 
  ; residuals
  ;
  res = y-yhat
  sigma = sqrt(var(res))
  p = (1:(n+1))~res
  l0 = gryline(0, #(0,n+1)) 
  l1 = gryline(sigma, #(0,n+1))
  l2 = gryline(-sigma, #(0,n+1))
  setmaskl(l1, (1:rows(l1))', 1, 1, 1) 
  setmaskl(l2, (1:rows(l2))', 1, 1, 1)
  l3 = gryline(3*sigma, #(0,n+1))
  l4 = gryline(-3*sigma, #(0,n+1))
  setmaskl(l3, (1:rows(l3))', 1, 1, 3)
  setmaskl(l4, (1:rows(l4))', 1, 1, 3)
  show (d, 1, 2, p, l0, l1, l2, l3, l4)
  title="Least squares residual plot"
  setgopt(d, 1, 2,"title",title) 
endp                         ; end of myquant
;
; call estimation function with beta #(-2,5) and outlier #(10,3)
;
library("graphic")
myquant(#(3,-6), #(-2,6))
