; -----------------------------------------------------------------
; Library        METRIC
; -----------------------------------------------------------------
;   Macro        metric05
; -----------------------------------------------------------------
;   Description  Illustrates estimation of a parametric 
;                self selection model.
; -----------------------------------------------------------------
library("metrics")
randomize(10178)
n	=	500
s1	=	1
s2	=	1
s12	=	0.7
ss	=	#(s1,s12)~#(s12,s2)
ev	=	eigsm(ss)
va	=	ev.values
ve	=	ev.vectors
ll	=	diag(va)
ll	=	sqrt(ll)
sh	=	ve*ll*ve'
u	=	normal(n,2)*sh'
z	=	2*normal(n,2)
g	=	#(1,2)
q	=	(z*g+u[,1].>=0)
x	=	matrix(n)~aseq(1, n ,0.25)
b	=	#(-9, 1)
y	=	x*b+u[,2]
y	=	y.*(q.>0)
heckit 	= 	heckman(x,y,z,q)
heckit.b
heckit.s
heckit.g
