; -----------------------------------------------------------------
; Library        QUANT
; -----------------------------------------------------------------
;   Macro        quant04
; -----------------------------------------------------------------
;   Description  Example quantlet defining a procedure.
; -----------------------------------------------------------------
  proc() = myquant()
    n = 10                         ; number of observations
    randomize(17654321)            ; sets random seed
    beta =#(1, 2)                  ; defines intercept and slope
    x = matrix(n)~sort(uniform(n)) ; creates design matrix     
    m = x*beta                     ; defines regression line
    eps = 0.05*normal(n)           ; creates obs error
    y = m + eps                    ; noisy line
    d = createdisplay(1,1)     
    dat = x[,2]~y                              
    tdat = x[,2]~m
    setmaskl(tdat, (1:rows(tdat))', 1, 1, 1) 
                                   ; thin blue line
    setmaskp(tdat, 0, 0, 0)        ; reduces point size to min
    beta1 = inv(x'*x)*x'*y
    yhat = x*beta1
    hdat = x[,2]~yhat
    setmaskl(hdat, (1:rows(hdat))', 4, 1, 3) 
                                   ; thick red line
    setmaskp(hdat, 0, 0, 0)    
    show(d, 1, 1, dat, tdat, hdat)
  endp