proc (res) = SPPPgetregion ()
;
; -----------------------------------------------------------------------
; Library      spatial 
; -----------------------------------------------------------------------
; See_also     SPPPinit SPPPinitrandom SPPPsetregion 
;              SPPPkfn SPPPpsim SPPPstrauss SPPPssi SPPPkenvl SPPPkaver
; -----------------------------------------------------------------------
; Macro        SPPPgetregion
; -----------------------------------------------------------------------
; Description  Retrieves the rectangular spatial domain that previously
;              has been set by SPPPinit or SPPPsetregion.
; -----------------------------------------------------------------------
; Usage        area = SPPPgetregion ()
; Input
;   None
; Output
;   Parameter  res
;   Definition 4 x 1  -  vector consisting of xl, xu, yl, and yu
; -----------------------------------------------------------------------
; Notes        C-Code from Venables, Ripley (1999) forms the basis of 
;              this quantlet. Also check this reference for more details.
; -----------------------------------------------------------------------
; Example      ; load the spatial statistics library
;	       library ("spatial")
;              ; read a spatial data set
;	       pines = read ("pines.dat")
;	       ; initialize a point process
;  	       pinesobj = SPPPinit (pines, 0, 96, 0, 100, 10)
;              ; retrieve the area
;              area = SPPPgetregion ()
; -----------------------------------------------------------------------
; Result       Rectangular spatial domain, consisting of xl, xu, yl, yu.
; -----------------------------------------------------------------------
; Reference    Venables, W. N., Ripley, B. D. (1999): Modern Applied
;              Statistics with S-Plus, Third Edition, Springer, New York 
; -----------------------------------------------------------------------
; Link         ../tutorials/spatialstart.html Spatial statistics tutorial
; -----------------------------------------------------------------------
; Author       Juergen Symanzik, 000725
; -----------------------------------------------------------------------
;
  res = 1:4
  regerror = -1
  ;
  os = getenv ("os")
  if (os == "windows")
    d = dlcall ("_VR_ppget", res, regerror)
  else  
    ; Unix
    d = dlcall ("VR_ppget", res, regerror)
  endif
  ;
  error (regerror == 0, "SPPP region not properly initialized -- use SPPPinit or SPPPsetregion first")
endp
