proc (m2) = VaRauxsums(vc,w,h)
; ----------------------------------------------------------------------------
; Library        VaR
; ----------------------------------------------------------------------------
;  See_also      VaRpred VaRest 
; ----------------------------------------------------------------------------
;   Macro        VaRauxsums
; ----------------------------------------------------------------------------
;   Description  subroutine for VaRpred (with option sums),
;                calculates the transformation matrix.
; ----------------------------------------------------------------------------
;   Usage        m2 = VaRauxsums(vc, w, h)
;   Input
;     Parameter   vc  
;     Definition        d x d  variance matrix
;     Parameter   w     
;     Definition        1 x d  weights vector
;     Parameter   h
;     Definition        scalar, the cutpoint
;   Output
;     Parameter   m2
;     Definition        m x d  transformation matrix (it sums 
;                       independent columns
; ----------------------------------------------------------------------------
;   Author    Zdenek Hlavka, 2000/07/13 
; ----------------------------------------------------------------------------
 vc=(vc.<h)
 d=rows(vc)
 zer=zeros(1,d)
 chck=matrix(1,d)
 i=1
 k=1
 m=unit(d)
 m2=zeros(d,d)
 while (i<=d)
  pom=vc[,i]
  if (chck[1,i]==1)
   pom=(cumsum(pom).*pom.==1)
   j=indexcat(pom,1)
   if (1-(j==-1))
     vc[i,]=zer
     vc[j,]=zer
     chck[1,j]=0
     m2[k,]=(trans(pom)).+m[i,]
     k=k+1
    else
     m2[k,]=m[i,]
     k=k+1
    endif
   endif
  i=i+1
  endo
 m2=m2[1:k-1,]
 m2=m2*w
endp
