proc ()=VaRdiagplot(int,sig,real,g)
; ----------------------------------------------------------------------------
; Library        VaR
; ----------------------------------------------------------------------------
;  See_also      VaRest VaRdiagtable VaRgrdiag
; ----------------------------------------------------------------------------
;   Macro        VaRdiagplot
; ----------------------------------------------------------------------------
;   Description  produces calibration and discrimination plots
;                which verify validity of probability forecasts.
; ----------------------------------------------------------------------------
;   Keywords     VaR
; ----------------------------------------------------------------------------
;   Usage        VaRdiagplot(int,sig,real,g)
;   Input
;     Parameter   int  
;     Definition        mx2 matrix containing intervals in the rows.
;     Parameter   sig
;     Definition        nx1 vector of predicted standard deviations 
;                           (assume normality)
;     Parameter   real
;     Definition        nx1 vector of realizations.
;     Parameter   g
;     Definition        scalar, number of grid points.
;   Output
;                       calibration and discrimination plot
; ----------------------------------------------------------------------------
;   Example      library("VaR")
;                x=read("kupfer")       ; time series
;                x=x[1:1001]  
;                y=diff(log(x))         ; returns
;                sig=VaRest(y)[,2]/qfn(0.99)   
;                y=y[251:1000] 
;                VaRdiagplot((-0.01~0.01),sig,y,10)
; ----------------------------------------------------------------------------
;   Author    Zdenek Hlavka, 2000/07/13 
; ----------------------------------------------------------------------------
  {freq,count,discr} = VaRgrdiag(int,sig,real,g)  
  VaRdiagdisp = createdisplay(2,1)
  show(VaRdiagdisp,1,1,freq)
  setgopt(VaRdiagdisp,1,1,"title","Frequency Plot")
  show(VaRdiagdisp,2,1,count)
  setgopt(VaRdiagdisp,2,1,"title","Calibration Plot")
  VaRdiagdisp2 = createdisplay(1,1)
  setgopt(VaRdiagdisp2,1,1,"title","Discrimination Plot")
  show(VaRdiagdisp2,1,1,discr)
endp
