proc (freq,calibr,discr)=VaRgrdiag(int,sig,real,g)
; ----------------------------------------------------------------------------
; Library        VaR
; ----------------------------------------------------------------------------
;  See_also      VaRest VaRpred VaRdiagplot VaRdiagtable VaRtimeplot
; ----------------------------------------------------------------------------
;   Macro        VaRgrdiag
; ----------------------------------------------------------------------------
;   Description  produces calibration and discrimination plots
;                which verify validity of probability forecasts.
; ----------------------------------------------------------------------------
;   Usage        {freq,calibr,discr}=VaRgrdiag(int,sig,real,g)
;   Input
;     Parameter   int  
;     Definition        mx2 matrix containing intervals in the rows.
;     Parameter   sig
;     Definition        nx1 vector of predicted standard deviations 
;                           (assume normality)
;     Parameter   real
;     Definition        nx1 vector of realizations.
;     Parameter   g
;     Definition        scalar, number of grid points.
;   Output
;     Parameter   freq  
;     Definition        graphical object containing rel. frequencies
;                       of the probability forecasts calculated on the
;                       given number of grid points.
;     Parameter   calibr
;     Definition        graphical object containing the calibration plot.
;     Parameter   discr
;     Definition        graphical object containing the discrimination plot.
; ----------------------------------------------------------------------------
;   Example     library("VaR")
;               x=read("kupfer")       ; time series
;               x=x[1:1001]  
;               y=diff(log(x))         ; returns
;               sig=VaRest(y)[,2]/qfn(0.99)   
;               sig2=VaRest(y,"EMA")[,2]/qfn(0.99)
;               y=y[251:1000] 
;               intervals=(-0.01~0.01)|(-0.017~0.017)|(-0.005~0.005)|(-0.002~0.002)
;               {fr1,ca1,di1}=VaRgrdiag(intervals,sig,y,5)
;               {fr2,ca2,di2}=VaRgrdiag(intervals,sig2,y,5)
;               disp=createdisplay(2,3)
;               show(disp,1,1,fr1)
;               show(disp,1,2,ca1)
;               show(disp,1,3,di1)
;               show(disp,2,1,fr2)
;               show(disp,2,2,ca2)
;               show(disp,2,3,di2)
;
; ----------------------------------------------------------------------------
;   Result    Graphics comparing two methods of VaR prediction from the
;             "probability forecasts" point of view.
; ----------------------------------------------------------------------------
;   Author    Zdenek Hlavka, 2000/07/13 
; ----------------------------------------------------------------------------
  table=VaRdiagtable(int,sig,real,g)
  rw=rows(table)
  scale=(1:rw)/g-1/(g+g)
  freq = setmask(scale~table[,1], "line")   
  calibr = setmask(scale~table[,2]./(table[,1]+(table[,1]==0)), "line")   
  discr=(scale~table[,2]./(sum(table[,2])))|(scale~table[,3]./(sum(table[,3])))
  setmaskl(discr, trans(1:rw)|trans((rw+1):(rw+rw)),0|0,1|4,2|2)
  setmaskp(discr, 0,0,0)
endp
