proc(rho,tau,critvalues)=adf(z,p,trend)
; ---------------------------------------------------------------------
; Library     times
; ---------------------------------------------------------------------
; See_also    kpss
; ---------------------------------------------------------------------
; Macro       adf
; ---------------------------------------------------------------------
; Description Calculation of the two tabulated testvalues (the general
;               one is tau) for the Augmented Dickey-Fuller Test of a 
;               unit root in an autoregressive process for with a 
;               constant. If the third argument is "trend" a linear
;               trend is calculated.
;               The third return value is a vector of critical 
;               values for tau.
; ---------------------------------------------------------------------
; Usage       {rho,tau,critvalues}=adf(z,p{,trend})
; Input       
; Parameter   y 
; Definition  series to be estimated
; Parameter   p 
; Definition  number of included past differences in the regression
; Parameter   trend 
; Definition  string (not needed), a linear trend is calculated if
;               trend = "trend"
; Output      
; Parameter   rho
; Definition  scalar, testvalue
; Parameter   tau
; Definition  scalar, testvalue
; Parameter   critvalues
; Definition  vector, critical values (1%, 5%, 10%, 90%, 95% and 99%);
;             these values are calculated for sample sizes (rows of y)
;               greater than 500
; ---------------------------------------------------------------------
; Example     
;       library("times")
;       randomize(1234)
;       x=normal(1000)
;       x=cumsum(x)
;       {rho,tau,cv}=adf(x,7)
;       rho
;       tau
;       cv
;       ; x is a random walk. thus we expect tau between -2.57 and -0.44
; ---------------------------------------------------------------------
; Result      
;       Contents of rho
;
;       [1,]   4.8222 
;
;       Contents of tau
;
;       [1,]  -1.8666 
;       
;       Contents of cv
;       
;       [1,]    -3.43 
;       [2,]    -2.86 
;       [3,]    -2.57 
;       [4,]    -0.44 
;       [5,]    -0.07 
;       [6,]      0.6 
; ---------------------------------------------------------------------
; Example     
;       library("times")
;       randomize(1234)
;       x=normal(1000)
;       x=cumsum(x)
;       {rho,tau,cv}=adf(x,7,"trend")
;       rho
;       tau
;       cv
;       ; x is a random walk. thus we expect tau between -3.12 and -1.25
; ---------------------------------------------------------------------
; Result      
;       Contents of rho
;       
;       [1,]   7.0198 
;       
;       Contents of tau
;       
;       [1,]  -2.0605 
;       
;       Contents of cv
;       
;       [1,]    -3.96 
;       [2,]    -3.41 
;       [3,]    -3.12 
;       [4,]    -1.25 
;       [5,]    -0.94 
;       [6,]    -0.33 
; ---------------------------------------------------------------------
; Keywords    Augmented Dickey-Fuller test, Cointegration, adf
; ---------------------------------------------------------------------
; Reference   Dickey, D., Fuller, W. "Distribution of the Estimators 
;       for autoregressive Time Series with a unit root" Journal 
;       of the American Statistical Association 74, page 427-431
;       Gourieroux, C., Monfort, A. "Time Series and dynamic
;       Models", Cambridge University Press, 1997 (original in 
;       french 1990 "Sries Temporelles et Modles Dynamiques by 
;       conomica" conomica)
;       Wayne A. Fuller, Introduction to Statistical Time Series, Wiley,
;       New York, 1976 
; ---------------------------------------------------------------------
; Link http://www.quantlet.de/scripts/fin/fhh.pdf
;      Statistics of financial markets
; Link http://www.quantlet.de/codes/fin/SFMAdfKpss.html
;      Application in financial markets
; Link http://ise.wiwi.hu-berlin.de/statistik/diplom/wuensche00/wuensche00.pdf
;      Diploma thesis of Arne Wuensche
; ---------------------------------------------------------------------
; Author     Kleinow, Wuensche 20000509
; ---------------------------------------------------------------------
//
n=rows(z)
critvalues = #(-3.43, -2.86, -2.57, -0.44, -0.07, 0.6)
if (exist("trend"))
  if (trend == "trend")
    temps = cumsum(matrix(n))
    ctemps = temps - mean(temps)
    cy = z - mean(z)
    betahat = sum(ctemps.*cy)/sum(ctemps^2)  
    constanthat = mean(z) - betahat*mean(temps)
    z=z-constanthat -betahat*temps
    critvalues = #(-3.96, -3.41, -3.12, -1.25, -0.94, -0.33)
  endif
endif
i=0
X=matrix(n-p-1,p+2)
while (i<n-p-1)
	i=i+1
	j=0
	while (j<p)
		j=j+1
		X[i,j+2]=z[i+p-j+1]-z[i+p-j]
	endo
endo    
X[,2]=z[(p+1:n-1)]
Y=z[(p+2:n)]
beta=inv(trans(X)*X)*trans(X)*Y
e=Y-X*beta
sigmae=var(e)
ymean=sum(z[(p+1:n-1)])/(n-p-1)
sumy=trans(z[(p+1:n-1)]-ymean)*(z[(p+1:n-1)]-ymean)
rho=(n-p-1)*(1-beta[2])
tau=(beta[2]-1)/sqrt(sigmae/sumy)
endp

