proc()=american()
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       european, mcmillan
; -----------------------------------------------------------------
;   Macro         american
; -----------------------------------------------------------------
;   Description   starting program to calculate option prices 
;                 for american options
; -----------------------------------------------------------------
;   Usage         american()
;   Input         
;   Output        
; -----------------------------------------------------------------
;   Example   library("finance")
;             american()
; -----------------------------------------------------------------
;   Result    option price of an american option 
;             using the formula of MC Millan
; -----------------------------------------------------------------
;   Author    S.Sperlich, R.Mohrmann  970301 
; -----------------------------------------------------------------
job=0
do
  selhead = "Choose the underlying asset for your option."
  selitem = "Stock"|"Exchange Rate" 
       sel1 = selectitem (selhead, selitem)
       if (sel1[1]) 
     	   selhead = "Do you want dividends to be included?"
           selitem = "No"|"Continually paid"|"Fixed, paid at time T" 
             sel2 = selectitem (selhead, selitem)
             if (sel2[1])
		job = 1 
             endif 
             if (sel2[2])
		job = 2
             endif
             if (sel2[3])
		job = 3
             endif
      endif 
      if (sel1[2])
        job = 4
      endif 
until(job)
  selhead = "What do You want to compute?"
  selitem = "Option Price"|"Implied Volatility" 
  sel3 = selectitem (selhead, selitem)
     if (sel3[1])
       {opv,poc,ingred} = bs1(job)
       ; ingred
       ing = ingred[6]
       if (ing>(1.0e-6))
         mcmillan(opv,poc,job,ingred)
       else
         setsize(400, 250)
         tex="if"|"  cost of carry >="
         tex= tex|"  riskless domestic interest rate"
         tex= tex|"like here then prices are equal for"
         tex= tex|"American and European options"
         lin=("-------------------------------------")
         aus= " "|lin|tex|lin|" " 
         aus
       endif
     endif 
     if (sel3[2])
        tex = "we recommend not to calculate"
        tex = tex|"   implied volatilities  "
	tex = tex|"by the McMillan approximation"
  	lin=("-------------------------------------")
  	aus= " "|lin|tex|lin|" " 
  	aus
     endif 
endp



