proc(y)=aorBgen(aorb,di,ord,adj,typ)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  agen, bgen
; ----------------------------------------------------------------------
;   Macro	  aorBgen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; ----------------------------------------------------------------------
;   Usage         y = aorBgen(aorb,di,ord,adj,typ)
;   Input 
;     Parameter   b 
;     Definition    di*ord+1 vector 
;     Parameter   di 
;     Definition    vector, dimensions
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   adj 
;     Definition    scalar, 1=if adjusted, 0=if not
;     Parameter   typ 
;     Definition     integer, describing the model type
;   Output
;     Parameter   y
;     Definition    matrix
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich  971106
; ---------------------------------------------------------------------- 
   if (adj==0)
    y = bgen(aorb,di,ord)    
   else
    y = agen(aorb,di,ord,typ)
   endif
endp
