proc(cab,stderr,lik,s2)=archest(xx,q,p)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  nelmin
; ----------------------------------------------------------------------
;   Macro	  archest
; ----------------------------------------------------------------------
;   Description   estimates a GARCH process with mean zero by QMLE
; ----------------------------------------------------------------------
;   Usage         y = archest(xx,q,p)
;   Input 
;     Parameter   xx 
;     Definition  vector
;     Parameter   q
;     Definition  1 or 2 (can be extended)
;     Parameter   p
;     Definition  1 or 2 (can be extended)
;   Output
;     Parameter   y
;     Definition  list containing 1. parameter estimates, 2. standard 
;		   errors, 3. likelihood value, 4. volatility estimate
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize (0)
;                 x=normal(100)
;                 z=archest(x,1,1)
;                 z{1}{1}
; ----------------------------------------------------------------------
;   Result       Contents of minimum   
;                [1,]  0.48528 
;                [2,]  0.0026728 
;                [3,]  0.53451 
; ----------------------------------------------------------------------
;   Author 	Christian Hafner, 960814
; ----------------------------------------------------------------------
  putglobal("xx")
  n=rows(xx)
  q=rint(q)                            ; ARCH order
  p=rint(p)                            ; GARCH order
  m=p+q+1
  error((q<1)||(q>2), "q must be 1 or 2") 
  error((p<1)||(p>2), "p must be 1 or 2")
  switch
      case ((p==1)&&(q==1))
        fun="garch11"          break    ; GARCH(1,1) model
      case ((p==1)&&(q==2))
        fun="garch21"          break    ; GARCH(2,1) model
      case ((p==2)&&(q==1))
        fun="garch12"          break    ; GARCH(1,2) model
      case ((p==2)&&(q==2))
        fun="garch22"          break    ; GARCH(2,2) model
  endsw
  start=uniform(m)./m                   ; starting values
  cab=nelmin(start,fun,200,1e-5)        ; optimizing the likelihood
  h1=cab[1]
  h2=matrix(m-1).*mean(xx^2)
  j=1
  while(j<=q)
      h1=h1+cab[1+j].*xx[q-j+1:n-j]^2
      j=j+1
  endo
  ex = h2[1:q]| h1
  s2 = genar(ex, h2[1:p], cab[q+2:m])  ; generation of cond. variance  
  s2der=matrix(n,m)
                      ; generation of the derivative of s2 w.r.t.:
  s2der[,1]=genar(matrix(n), matrix(p), cab[q+2:m])   ; the constant
  i=1
  while(i<=q)                           ; the ARCH parameters 
    s2der[,i+1]=genar(h2[1:q]| xx[q-i+1:n-i]^2 , h2[1:p], cab[q+2:m])
    i=i+1
  endo
  while(i<m)                            ; and the GARCH parameters
    s2der[,i+1]=genar( h2 | s2[m-i:n-i] , h2[1:p], cab[q+2:m])
    i=i+1
  endo
  ku=mean((xx-mean(xx))^4)/(mean(xx^2))^2  ; unconditional kurtosis
  kc=ku.*((mean(s2))^2/mean(s2^2))      ; conditional kurtosis
  g1=(0.5/(s2^2).*s2der)' * s2der./n    ; Hessian matrix
  g2=(0.25/(s2^2).*s2der.*(kc-1))' * s2der./n ; outer product 
  ascov=inv(g1)*g2*inv(g1)              ; asymptotic covariance matrix
  stderr=matrix(m)  
  i=1  
  while(i<=m)  
    stderr[i]=sqrt(ascov[i,i]/n)        ; standard errors 
    i=i+1  
  endo  
  lik=-n/2*log(2*pi)-0.5*sum(log(s2)+(xx^2)./s2) ; log likelihood value
endp
;----------------------------------------------------------------------
proc(y)=garch11(a)
  xx=getglobal("xx")
  n = rows(xx)
  ex = 0 | a[1] + a[2].*xx[1:n-1]^2 
  s2=genar(ex, mean(xx^2), a[3])
  if(sum((a<=0)>=1) ||  (sum(a[2:3])>=1))
    y=1e+10
  else
    y=sum(log(s2)+(xx^2)./s2)
  endif
endp
proc(y)=garch12(a)
  xx=getglobal("xx")
  n = rows(xx)
  ex = 0 | a[1] + a[2].*xx[1:n-1]^2 
  s2 = genar(ex, matrix(2).*mean(xx^2), a[3:4])
  if(sum((a<=0)>=1) ||  (sum(a[2:4])>=1))
    y=1e+10
  else
    y=sum(log(s2)+(xx^2)./s2)
  endif
endp
proc(y)=garch21(a)
  xx = getglobal("xx")
  n = rows(xx)
  ex = 0 | mean(xx^2) | a[1] + a[2].*xx[2:n-1]^2 + a[3].*xx[1:n-2]^2
  s2 = genar(ex, mean(xx^2), a[4])
  if(sum((a<=0)>=1) ||  (sum(a[2:4])>=1))
    y=1e+10
  else
    y=sum(log(s2)+(xx^2)./s2)
  endif
endp
proc(y)=garch22(a)
  xx=getglobal("xx")
  n = rows(xx)
  ex = matrix(2) | a[1] + a[2].*xx[2:n-1]^2 + a[3].*xx[1:n-2]^2
  s2 = genar(ex, matrix(2).*mean(xx^2), a[4:5])
  if(sum((a<=0)>=1) ||  (sum(a[2:5])>=1))
    y=1e+10
  else
    y=sum(log(s2)+(xx^2)./s2)
  endif
endp
