proc(data)=arcsin(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istatransformation
; -----------------------------------------------------------------------
; Macro        arcsin
; -----------------------------------------------------------------------
; Description  performs a arcus sinus transformation of the selected 
;              variables in ISTA. The transformed variables can replace
;              the original ones or can be appended on the end of data.x.
;              the type is automatically set continuous.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data    = datain
  datah   = datain
  datah1   = paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
  ind=paf(1:rows(data), data.rowcase&&data.randcase&&data.rowmissing) 
  stringh = data.colname
  colth   = data.coltype
  colvh   = data.colvar  
  colmh   = data.colmissing
  n=rows(data.x)
  text="[sqrt(n+c1)*(arsin(sqrt((x+c2)/(n+c3)))]"
  sel=choosevariable2(data,text)
  i = 0
  while (i.<rows(sel))
    i = i+1
    if(sel[i])
      m = min(datah[,i])
      if (m<0)
        vs = 0|abs(m)+1|0  ;x+c2>0
      else
        vs = 0|0|0    
      endif
      vstr = stringh[i] + " c1:"|stringh[i] + " c2:"|stringh[i] + " c3:"
      doit = 0  
      do
        v    = readvalue(vstr, vs)    
        if((m<0)&&(v<abs(m))|(n+v[1]<=0)|(n+v[3]<=0))
          sel1 = selectitem("Warning: Sqrt(arg) with arg <=0", "Do it !"|"New c ?", "single")
           if (sel1[1])
            doit = 1
          endif
          if (sel1[2])
            doit = 0
          endif
        else
          doit = 1
        endif
      until (doit)
      ;choose c1, c2, c3,  until arg(sqrt) >0
      ;or until user accepts NaN
      selhead2="Create a new variable?"
      selitem2="Yes"|"No"
      sel2=selectitem(selhead2,selitem2,"single")
      if(sel2[2])  
        xneu=NaN*matrix(rows(data))
        xneu[ind]=sqrt(n+v[1])*(asin(sqrt((datah1[,i]+v[2])/(n+v[3]))))
        datah[,i]=xneu    
      endif
      if(sel2[1]) 
        xneu=NaN*matrix(rows(data))
        xneu[ind]=sqrt(n+v[1])*(asin(sqrt((datah1[,i]+v[2])/(n+v[3]))))
        datah=datah~xneu
        stringh1=string("X%.0f", cols(datah)) 
        stringh=stringh|readvalue("New variablename:", stringh1)
        colth=colth|0 ;new variable continuous
        colvh=colvh|1 ;new variable not deleted
        colmh=colmh|1 ;new variable not deleted 
      endif
    endif
  endo
  data.x=datah
  data.colname=stringh
  data.coltype=colth
  data.colvar=colvh
  data.colmissing=colmh
endp



