proc(obj)=barchartrech(x, w, n)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     barchart doista grbar grscale gruppenvariable2 
;              istagraphic showd 
; -----------------------------------------------------------------------
; Macro        barchartrech
; -----------------------------------------------------------------------
; Description  computes the barchart of selected variables 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  if((rows(x).>1)&&(var(x)>0))        ;two datapoints are needed and no
                                      ;misssings
    obj=grbar(x,w)                    ;computes the composed object   
    obj = grscale(obj,#(1,rows(x)/n)) ;scaling of data
  else
    obj="One realization only"|"or missing(s):"|"no barchart possible"
  endif
endp


