
proc(X1n)=Callk(C1,K1,Sn,a)
  if  (Sn<=K1)
    X1n=-C1*a
  else
    X1n=(Sn-K1-C1)*a
  endif
endp
;
proc(X3n)=Callv(C2,K2,Sn,a)
  if  (Sn<=K2)  
    X3n=C2*a
  else
    X3n=(C2+K2-Sn)*a
  endif
endp
;
;;;;;  main part  ;;;;;;
;
proc(summ)=callbull()
; -----------------------------------------------------------------
; Library  	      finance
; -----------------------------------------------------------------
;  See_also       american, bitree, bs1, european, mcmillan, optstart
; -----------------------------------------------------------------
;   Macro         callbull
; -----------------------------------------------------------------
;   Description   calculates the results of a Bull Call Spread
;                 for the context of option pricing
; -----------------------------------------------------------------
;   Usage         callbull()
;    Input        
;    Output
;     Parameter   summ
;     Definition  string matrix, table of results             
; -----------------------------------------------------------------
;   Example       library("finance")
;                 callbull()
; -----------------------------------------------------------------
;   Result  the following table of results:
;   Contents of summ
;  [ 1,] " "
;  [ 2,] "  Stock price    long Call   short Call    gain/loss"
;  [ 3,] "----------------------------------------------------"
;  [ 4,] "       540.00     -3500.00      1500.00     -2000.00"
;  [ 5,] "       550.00     -3500.00      1500.00     -2000.00"
;  [ 6,] "       560.00     -2500.00      1500.00     -1000.00"
;  [ 7,] "       570.00     -1500.00      1500.00         0.00"
;  [ 8,] "       580.00      -500.00      1500.00      1000.00"
;  [ 9,] "       590.00       500.00      1500.00      2000.00"
;  [10,] "       600.00      1500.00      1500.00      3000.00"
;  [11,] " "
; -----------------------------------------------------------------
;   Author    Schmidt, Sperlich  970217 
; -----------------------------------------------------------------
;
  x = 540|610|550|35|600|15|100                  ; Beispielzahlen
  s = "lowest quotation"|"highest quotation"
  s = s |"Strike price of long call (C1)"|"Price for C1"
  s = s |"Strike price of short call (C2)"|"Price for C2"
  s = s |"Number of contracts"
  x = readvalue(s, x)
  S=0
  X1=0
  X2=0
  X3=0
  Sn=x[1]
  while(Sn<x[2])
    S = S|Sn
    X1n = Callk (x[4],x[3],Sn,x[7])
    X1 = X1|X1n
    X3n = Callv (x[6],x[5],Sn,x[7])
    X2n = X1n + X3n
    X2 = X2|X2n
    X3 = X3|X3n
    Sn = Sn+10        ; Aktienkurse werden in Zehnerschritten 
  endo
  e=S~X1~X3~X2
  e=e[2:rows(e),]
  j=0
  while (j<cols(e))
      j=j+1
      if (j==1)
        summtxt=string("%13.2f",e[,1])
      else
        summtxt=summtxt+string("%13.2f",e[,j])
      endif
  endo
  summ=      ("  Stock price"|"-------------")
  summ= summ+("    long Call"|"-------------")
  summ= summ+("   short Call"|"-------------")
  summ= summ+("    gain/loss"|"-------------")
  summ= " "|summ|summtxt|" "
endp
