proc(dK,cK,mK)=canbw(K)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      uni tri trian epa qua gau cosi canker
; -----------------------------------------------------------------
;   Macro        canbw
; -----------------------------------------------------------------
;   Keywords     kernel smoothing, canonical kernels
; -----------------------------------------------------------------
;   Description  does the canonical bandwith transformation 
;                of a bandwith value of kernel K1 into an 
;                equivalent bandwidth for Kernel K2. 
; -----------------------------------------------------------------
;   Reference    Marron/Nolan (1988): Canonical kernels for density
;                estimation
;  
;                Haerdle (1991): Smoothing Techniques, p. 220
; -----------------------------------------------------------------
;   Usage        {dK, cK, mK} = canbw(K)
;   Input
;     Parameter  K1
;     Definition   string, kernel function on [-1,1] or "gau".
;   Output
;     Parameter  dK 
;     Definition   canonical bandwidth for K.
;     Parameter  cK 
;     Definition   squared L2 mnorm of K.
;     Parameter  mK 
;     Definition   second moment of K.
; -----------------------------------------------------------------
;   Example   library("smoother") 
;             {dK, cK, mK} = canbw("qua")
;             dK ~ 35^0.2    ; dK should be 35^0.2 
;             cK ~ 5/7       ; cK should be 5/7
;             mK ~ 1/7       ; mK should be 1/7
; -----------------------------------------------------------------
;   Result    Contents of _tmp
;             [1,]   2.0362   2.0362 
;             Contents of _tmp
;             [1,]  0.71429  0.71429 
;             Contents of _tmp
;             [1,]  0.14286  0.14286 
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 990209  
; -----------------------------------------------------------------
  allK="uni"|"trian"|"epa"|"qua"|"tri"|"gau"|"cosi"
  alcK=(0.5)|(2/3)  |(0.6)|(5/7)|(350/429)|(1/(2*sqrt(pi)))|(pi^2/16)
  almK=(1/3)|(1/6)  |(0.2)|(1/7)|(1/9)|(1.0)|(1-8*pi^2)
;
  iK=sum((allK==K).*(1:rows(allK)))
  if (iK>0)
    cK=alcK[iK]
    mK=almK[iK]
  else
    g=grid(-0.995,0.01,200)
    cK=sum((_K(g))^2)*0.01
    mK=sum((_K(g)).*g^2)*0.01
  endif
  dK=(cK/(mK^2))^0.2
endp