proc (z) = cceil (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cfloor 
; -----------------------------------------------------------------------
; Macro        cceil
; -----------------------------------------------------------------------
; Description  Computes ceil for a complex array
; -----------------------------------------------------------------------
; Usage        z = cceil (x)
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (1.5, -1.5)
;              cceil (z)
; -----------------------------------------------------------------------
; Result       Contents of z.re
;              [1,]        2 
;              Contents of z.im
;              [1,]       -1 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960327, 970530
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cceil : No real part in x found")
  error (comp(x, "im")<1, "cceil : No imaginary part in x found")
  re = ceil(x.re)
  im = ceil(x.im)
  z  = list (re, im)
endp

