proc (r) = cdfx (dist, x, shape)
; -----------------------------------------------------------------
;   Library       stats
; -----------------------------------------------------------------
;   See_also      randx qfx pdfx
; -----------------------------------------------------------------
;   Macro         cdfx
; -----------------------------------------------------------------
;   Description   cdfx returns the value of the extreme value and
;                 generalized Pareto distribution functions for 
;                 elements of a vector.
; -----------------------------------------------------------------
;   Usage         r = cdfx(dist, x, shape)
;   Input
;     Parameter   dist
;     Definition      name of distribution: "ev", "ev0", "ev1", "ev2", "gp", "gp0", "gp1" or "gp2"
;     Parameter   x
;     Definition      vector
;     Parameter   shape
;     Definition      shape parameter
;   Output
;     Parameter   r
;     Definition      vector
; -----------------------------------------------------------------
;   Example   library("stats")
;             cdfx("ev0", 1.7)
; -----------------------------------------------------------------
;   Result    0.83303
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
if (dist == "ev0")
  r = exp (-exp (- x))
endif
if (dist == "ev1")
  n = rows (x)
  r = zeros (n, 1)
  ind = x >= 0
  if (sum (ind) > 0)
    i = paf (1:n, ind)
    r [i] = exp (-x [i]^(-shape))
  endif
endif
if (dist == "ev2")
  n = rows (x)
  r = zeros (n, 1)
  ind = x > 0
  if (sum (ind) > 0)
    i = paf (1:n, ind)
    r [i] = 1
  endif
  ind = x < 0
  if (sum (ind) > 0)
    i = paf (1:n, ind)
    r [i] = exp (-(-x [i])^(-shape))
  endif
endif
if (dist == "ev")
  if (abs (shape) < 1e-10)
    r = cdfx ("ev0", x)
  else
    n = rows (x)
    if (shape > 0)
      r = zeros (n, 1)
    else
      r = matrix (n);
    endif
    if (shape > 0)
      ind = x > -1 / shape
    else
      ind = x < -1 / shape
    endif
    if (sum (ind) > 0)
      i = paf (1:n, ind)
      r [i] = exp (-(1 + shape * x [i])^(-1/shape))
    endif
  endif
endif
if (dist == "gp0")
  n = rows (x)
  r = matrix (n) - 1
  if (sum (x >= 0) > 0)
    i = paf (1:n, x >= 0)
    r [i] = 1 - exp(-x [i])
  endif
endif
if (dist == "gp1")
  n = rows (x)
  r = zeros (n, 1)
  ind = x >= 1
  if (sum (ind) > 0)
    i = paf (1:n, ind)
    r [i] = 1 - x [i]^(-shape)
  endif
endif
if (dist == "gp2")
  n = rows (x)
  r = matrix (n) - 1
  if (sum (x > -1 && x < 0) > 0)
    i = paf (1:n, x > -1 && x < 0)
    r [i] = 1 - (-x [i])^(-shape)
  endif
  if (sum (x >= 0) > 0)
    i = paf (1:n, x >= 0)
    r [i] = 1
  endif
endif
if (dist == "gp")
  if (abs (shape) < 1e-10)
    r = cdfx ("gp0", x)
  else
    n = rows (x)
    r = matrix (n) - 1
    if (shape > 0)
      ind = x > 0
      if (sum (ind) > 0)
	i = paf (1:n, ind)
	r [i] = 1 - (1 + shape * x [i]) ^ (-1/shape)
      endif
    else
      ind = x > 0 && x < -1/shape
      if (sum (ind) > 0)
	i = paf (1:n, ind)
	r [i] = 1 - (1 + shape * x [i]) ^ (-1/shape)
      endif
      ind = x >= -1 /shape
      if (sum (ind) > 0)
	i = paf (1:n, ind)
	r [i] = 1
      endif
    endif
  endif
endif

error (exist ("r") <= 0, "Distribution " + dist + " unknown")
endp
