proc(data)=changetype(datain)  
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata
; -----------------------------------------------------------------------
; Macro        changetype
; -----------------------------------------------------------------------
; Description  changes the types of selected variables and shows if they
;              excluded or included
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
data=datain
colv=string("%-10.10s",data.colname )
 selhead="Choose variables"
  typestr=string(" ",1:rows(data.colname))
  deletestr=string(" ",1:rows(data.colname))
  if(sum(data.coltype)==0)              ;all variables continuous
    if(sum(1-data.colvar)==0)           ;all variables included
      deletestr=string(" included",1:rows(data.colname)) 
    else                                ;some variables excluded
      selk=paf(1:rows(data.colname),(data.colvar==0)) 
      deletestr[selk]=string(" excluded",data.colvar[selk])
      selk1=paf(1:rows(data.colname),(data.colvar==1)) 
      deletestr[selk1]=string(" included",data.colvar[selk1]) 
   endif
    typestr=string(" continuous",1:rows(data.colname))
    selitem="all"|(colv+" "+typestr+deletestr )
  else                                  ;different kinds of type 
    if(sum(1-data.colvar)==0)           ;all variables included
      deletestr=string(" included",1:rows(data.colname)) 
    else                                ;some variables deleted
      selk=paf(1:rows(data.colname),(data.colvar==0)) 
      deletestr[selk]=string(" excluded",data.colvar[selk])
      selk1=paf(1:rows(data.colname),(data.colvar==1)) 
      deletestr[selk1]=string(" included",data.colvar[selk1]) 
    endif 
    deletestr=string("%.10s",deletestr)
    if(sum(1-data.coltype))
      selh=paf(1:rows(data.colname),(data.coltype==0))
      typestr[selh]=string(" continuous",data.coltype[selh])
    endif
    selh1=paf(1:rows(data.colname),data.coltype==1)
    typestr[selh1]=string(" discrete  ",data.coltype[selh1])   
    selitem="all"|(colv+typestr+deletestr)
  endif
  selhelp = selectitemlist(selhead,selitem,15)
  r=rows(selhelp)
  if (selhelp[1]==1)
      sel=1*matrix(r-1) 
  else
    sel=selhelp[2:r]
  endif
  data.coltype=((sel||data.coltype)<>(sel&&data.coltype))
endp
