proc(y)=coeffba(di,ord,tb,te,covu,zz,a,la,th,typ,ytt)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      coeffest covmwgen
; -----------------------------------------------------------------
;   Macro         coeffba
; -----------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; -----------------------------------------------------------------
;   Usage         y = coeffba(di,ord,tb,te,covu,zz,a,la,th) 
;   Input
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   covu 
;     Definition    matrix, covariance
;     Parameter   zz 
;     Definition    matrix
;     Parameter   a 
;     Definition    vector
;     Parameter   la 
;     Definition    vector
;     Parameter   th 
;     Definition    vector
;     Parameter   typ 
;     Definition    integer, model type
;     Parameter   ytt
;     Definition    matrix, the time series
;   Output
;     Parameter   y
;     Definition     matrix 
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971121, CH 980428
; -----------------------------------------------------------------
   v=kron((aseq(1,ord,1)/la)^2 , xdiag(covu))
  odi=ones(di,1)/th^2
  oord=ones(ord,1)
  ey=eye(di*ord+1)
  zmy=ymulz(ord,di,tb,te,0,typ,ytt)'
  b=zeros(1,di*ord+1)
  k=1
  while (k<=di)
    v2=odi
    v2[k,]=1
    v2=kron(oord,v2)
    vk=diagrv(ey, 0|v/covu[k,k].*v2)
    b=b|(inv(vk+zz/covu[k,k]) * (vk*a[,k]+zmy[,k]/covu[k,k]))'
    k=k+1
  endo
y=b[2:k,]
endp;
