proc(c)=contmax(h) 
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     pswap conting measure agglom kmeans
; -----------------------------------------------------------------------
; Macro        contmax
; -----------------------------------------------------------------------
; Description  computes a linkage table between the rows and
;              columns of a contingency table by maximum value
;              of correspondence. The number of correspondences
;              is the minimum of number or dimensions of the
;              contingency table.
; -----------------------------------------------------------------------
; Usage        c = contmax (h) 
; Input
;   Parameter  h
;   Definition n x m  matrix (for instance, a contingency table
; Output
;   Parameter  c
;   Definition l x 2  matrix of the category labels of the rows
;              (first column) which correspond to the category
;              labels of the columns (second column)
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate contingency table
;             h=#(20, 1, 3, 0, 4)~#(1, 7, 25, 6, 11)~#(3, 2, 1, 4, 5)~#(1, 6, 0, 0, 0)~#(0, 0, 1, 9, 1)
;             contmax(h)
; -----------------------------------------------------------------------
; Result      Content of object c
;
;             [1,]        3        2 
;             [2,]        1        1 
;             [3,]        4        5 
;             [4,]        2        4 
;             [5,]        5        3 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111 
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  g=h 
  m=cols(h) 
  l=rows(h) 
  n=m 
  if (l<m) 
     n=l
  endif
  c=0.*matrix(n, 2)
  i=1
  while(i.<=n)
    r=max(max(g, 2))
    j=0
    do
      j=j+1
      k=0
      do
         k=k+1
         if((r.=g[j,k]) && (c[i,1].=0))
           c[i,1]=j
           c[i,2]=k
        endif
      until(k.=m)
    until(j.=l)
    k=0
    do
      k=k+1
      j=c[i,1]
      g[j,k]=-100000
    until(k.=m)
    j=0
    do
      j=j+1
      k=c[i,2]
      g[j,k]=-100000
    until(j.=l)
    i=i+1  
  endo  
endp  


