proc (z) = csortcol(x, c)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     csort
; -----------------------------------------------------------------------
; Macro        csortcol
; -----------------------------------------------------------------------
; Description  sorts with respect to either a real part of a column
;	or an imaginary part of a column c.
;	If 1 <= c <= cols(xr) it sorts after the real part of x, if 
;	cols(xr) < c <= cols(xr)+cols(xi) it sorts the imaginary part after 
;	column c-cols(xr).  
; -----------------------------------------------------------------------
; Usage        z = csortcol(x, c)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
;   Parameter  c
;   Definition scalar   column of x
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn array   real part of sorted x 
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(1,2)~#(2,3), #(2,1)~#(1,1))
;	       c  = 3
;	       csortcol(x, c)
; -----------------------------------------------------------------------
; Result      
;	Contents of z.re
;	[1,]        2        3 
; [2,]        1        2 
; Contents of z.im
;	[1,]        1        1 
; [2,]        2        1   
; -----------------------------------------------------------------------
; Keywords     complex numbers, sorting
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 920424, 970529, Susanne Hannappel, 960423
; -----------------------------------------------------------------------        error (comp(x, "re")<1, "csortcol : No real part in x found")
  error (comp(x, "im")<1, "csortcol : No imaginary part in x found")
  error (c < 1,  "csortcol : Can't sort this column")
  error (c > cols(x.re)+cols(x.im), "csortcol : Can't sort this column")
  s  = sort(x.re~x.im, c)
  re = s[,1:cols(x.re)]
  im = s[,cols(x.re)+1:cols(s)]
  z  = list(re,im)
endp



