proc (z) = csqrt (x) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos, ccosh, cexp, cln, csin, csinh, ctan, ctanh 
; -----------------------------------------------------------------------
; Macro        csqrt 
; -----------------------------------------------------------------------
; Description  Complex squareroot  
; -----------------------------------------------------------------------
; Usage        z = csqrt(x)
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(4,16), #(9,1))
;	             csqrt(x)
; -----------------------------------------------------------------------
; Result       Contents of z.re 
;		           [1,]   2.6314 
;              [2,]    4.002 
;	             Contents of z.im
;	             [1,]   1.7101 
;              [2,]  0.12494 
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 920424, 970529, Susanne Hannappel, 960423
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "csqrt : No real part in x found")
  error (comp(x, "im")<1, "csqrt : No imaginary part in x found")
  r  = sqrt (sqrt (x.re^2+x.im^2)) 
  t  = atan2(x.im,x.re)/2
  re = r .* cos(t) 
  im = r .* sin(t) 
  z  = list(re,im)
endp 


