proc (z) = ctanh (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos, ccosh, cexp, cln, csin, csinh, csqrt, ctan 
; -----------------------------------------------------------------------
; Macro        ctanh 
; -----------------------------------------------------------------------
; Description  Complex tangens hyperbolicus
; -----------------------------------------------------------------------
; Usage        z = ctanh(x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(4,16), #(9,1))
;	             ctanh(x)
; -----------------------------------------------------------------------
; Result       Contents of z.re 
; 	           [1,]  0.99956 
;              [2,]        1 
;	             Contents of z.im 
; 		         [1,]  0.00027638 
;              [2,]  2.1313e-14 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 920424, 960423, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "ctanh : No real part in x found")
  error (comp(x, "im")<1, "ctanh : No imaginary part in x found")
  r  = cosh(2*x.re) + cos(2*x.im)
  re = sinh(2*x.re)./r
  im = sin(x.im)./r
  z  = list(re,im)
endp



