proc(data)=deletecase(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata
; -----------------------------------------------------------------------
; Macro        deletecase
; -----------------------------------------------------------------------
; Description  deletes selected cases from the data set
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  if(rows(data.x)<=200)
    selhead="Choose case"
    deletestr=string("                 ",1:rows(data.rowcase))
    if((sum(1-data.rowcase)==0)&&(sum(1-data.randcase)==0)&&(sum(1-data.rowmissing)==0))          
    ;all cases included
      deletestr=string("   included!",1:rows(data.rowcase)) 
    else                                
    ;some variables excluded
      selk=paf(1:rows(data.rowcase),((data.rowcase==0)||(data.randcase==0)||(data.rowmissing==0))) 
      deletestr[selk]=string("           excluded",data.rowcase[selk])
      selk1=paf(1:rows(data.rowcase),((data.rowcase==1)&&(data.randcase==1)&&(data.rowmissing==1)))  
      deletestr[selk1]=string("           included",data.rowcase[selk1]) 
    endif
    selitem=string("Case%.0f",1:rows(data.x))+deletestr
    sel=selectitemlist(selhead,selitem,15)
    error(sum(sel).=rows(sel),"analyze: no case left")
    rowcase=((sel||data.rowcase)<>(sel&&data.rowcase))
    randcase=((sel||data.randcase)<>(sel&&data.randcase))
    rowmissing=((sel||data.rowmissing)<>(sel&&data.rowmissing))
    rowcase1=((sel&&data.rowcase&&data.randcase&&data.rowmissing)<>(sel||data.rowcase||data.randcase||data.rowmissing))
    randcase1=((sel&&data.rowcase&&data.randcase&&data.rowmissing)<>(sel||data.rowcase||data.randcase||data.rowmissing))
    rowmissing1=((sel&&data.rowcase&&data.randcase&&data.rowmissing)<>(sel||data.rowcase||data.randcase||data.rowmissing))
    data.rowcase=rowcase||rowcase1
    data.randcase=randcase||randcase1
    data.rowmissing=rowmissing||rowmissing1
  else
    "Attention: too many cases, not computable!"  
  endif
endp