proc(wg,b,sk,sdv,skl,slv,lk,iter)=dpls(w,d,dy,dl,y,lag,genau)
; -----------------------------------------------------------------
;   Library       metrics
; -----------------------------------------------------------------
;   See_also      glm, redun, makedesign 
; -----------------------------------------------------------------
;   Macro         dpls
; -----------------------------------------------------------------
;   Description   calculating latent variables, weights, loadings 
;                 and path coefficients with dynamic partial least
;                 squares algorithm
; -----------------------------------------------------------------
;   Usage         {wg,b,sk,sdv,skl,slv,lk,iter} = dpls(w,d,dy,dl,y,lag,genau)
;   Input
;     Parameter   w
;     Definition      a matrix with start weights same dimensions as dy
;     Parameter   d
;     Definition      a kxk matrix with inner unlagged designs (0 or 1) 
;                     no diagonal values allowed
;     Parameter   dy
;     Definition      a lxk matrix with outer designs (0 or 1) 
;                     rows are counting manifest variables
;     Parameter   dl
;     Definition      a kxk matrix with inner lagged designs (0 or 1) 
;                     diagonal elements are showing autoregression
;     Parameter   y
;     Definition      a nxl matrix with manifest variables (indicators)
;     Parameter   lag
;     Definition      a scalar of lag order
;     Parameter   genau
;     Definition      a scalar with canceling criterion
;   Output
;     Parameter   wg
;     Definition      a matrix with weights
;     Parameter   b
;     Definition      a matrix with loadings
;     Parameter   sk
;     Definition      a matrix with path coefficients with dimensions 
;                     like d (kxk)
;     Parameter   sdv
;     Definition      a matrix with standarddeviations of path 
;                     coefficients with dimensions like d (kxk)
;     Parameter   skl
;     Definition      a matrix with lagged path coefficients with 
;                     dimensions like d (kxk) and ordered like designed
;     Parameter   slv
;     Definition      a matrix with standarddeviations of path 
;                     coefficients with dimensions like d (kxk)
;     Parameter   lk
;     Definition      a matrix with latent variables
;     Parameter   iter
;     Definition      a scalar shows how many iterations used
; -----------------------------------------------------------------
;   Example   library("xplore")
;             y=read("indikat.dat")    
;             dy=read("dy.dat")
;             d=read("d.dat")
;             dl=read("dl.dat")
;             w=dy
;             {wg,b,sk,sdv,skl,slv,lk,iter}=dpls(w,d,dy,dl,y,1,3)
; -----------------------------------------------------------------
;   Result    
; Content of subject wg
; [1,]  0.0041037        0        0 
; [2,]  0.0012524        0        0 
; [3,] -6.9495e-05       0        0 
; [4,]  0.005811         0        0 
; [5,]        0  0.015399         0 
; [6,]        0  0.0021495        0 
; [7,]        0  0.0070099        0 
; [8,]        0        0    0.01665 
; [9,]        0        0    0.0046898
;
; Content of object b
; [1,]   78.476        0        0 
; [2,]   23.739        0        0 
; [3,]   -3.259        0        0 
; [4,]   111.51        0        0 
; [5,]        0   54.125        0 
; [6,]        0   6.5044        0 
; [7,]        0   21.761        0 
; [8,]        0        0   55.625 
; [9,]        0        0   15.746 
;
; Content of object sk
; [1,]        0        0        0 
; [2,]        0        0        0 
; [3,]   1.3396   0.0182        0 
;
; Content of object skl
; [1,]        0        0        0 
; [2,]        0        0        0 
; [3,]  -0.8048        0   0.4273 
;
; Content of object lk
; [1,]  -1.6271  -1.5907  -1.5722  -1.4829 ...
; [2,]  -1.6089  -1.5927    -1.59  -1.5687 ...
; [3,]  -2.2242   -1.928   -1.874  -1.5195 ...
;
; Content of object iter
; [1,]        3 
; -----------------------------------------------------------------
;   Author    Prof.Dr.H.G.Strohe Universitaet Potsdam; 
;             programmed by Dipl.-Vw. Frank Geppert; 
;             See for details: "DPLS Algorithmus und Computerprogramm
;             fuer dynamische Partial-Least-Squares-Modelle"
; -----------------------------------------------------------------
b=w
y=y'                                            ; Variablen zeilenweise
n=dim(w)                                        ; Dimensionen
h=n[2,1]                                        ; Anzahl latenter Variablen

n=n[1,1]                                        ; Anzahl manifester Variablen

m=dim(y)

m=m[2,1]-2*lag                                  ; Anzahl Beobachtungen

dlp=matrix(h,h)                                 ; Designmatrix positiver Lags

i=0
do                                              ; Diagonalelemente = 0

 i=i+1
 dlp[i,i]=0

until (i==h)
endv=0                                          ; Abbruchbedingung

iter=0                                          ; Anzahl Iterationen

 dd=d+d'

 y = (y'-mean(y'))'                             ; Zentrierung der Manifesten

 t=w'*y                                         ; Schaetzen von Latenten MPY
 t=t/(sqrt(var(t')))'                           ; Standardisieren

while (endv != 1)                               ; Solange keine Gleichheit

 walt=w                                         ; Gleichheitsvergleichsvariabl

 tn=t[,(lag+1):(m+lag)]                         ; Reihe ohne Lag 

 tl=t[,(1:m)]                                   ; Reihe mit Lag(t,1)

 tf=t[,(lag*2+1):(m+lag*2)]                     ; Reihe mit positivem Lag
 c=(tn*tn'/(m-1))'                              ; Korrelation * = MPY
 ac=(tn*tl'/(m-1))'                             ; Autokorrelation

 ds=dd.*c                                       ; Designkorrelation .* als *
 da=dl.*ac                                      ; Designautokorrelation

 t=ds*tn+da*tl+(da.*dlp)'*tf                    ; gewichtet Summieren
  j=1

 while (j <= h)                                 ; Regressionen alle Lat.

  i=1
  while (i <= n)                                ; Regression alle Manif.

   if (dy[i,j]==1)
    coef=gls(t[j,]',y[i,(2:(m+1))]')
    w[i,j]=coef

   endif

   i=i+1 

  endo

  j=j+1

 endo

 w=dy.*w                                        ; Regressionsmatrix berichtig.

 t=w'*y                                         ; Latente schaetzen

 sd=sqrt(var(t[,2:(m+1)]'))'                    ; Standardisierungsfaktor

 t=t/sd                                         ; Standardisieren

 if (floor(walt*10^genau) == floor(w*10^genau))

  endv = 1

 endif

 iter=iter+1

endo
w=w/sd'

;-------------------- Schritt 2 ------------------------------------------ 

j=1

 while (j <= h)                                 ; Regressionen alle Lat.

  i=1

  while (i <= n)                                ; Regression alle Manif.

   if (dy[i,j]==1)

    coef=gls(t[j,2:(m+1)]',y[i,2:(m+1)]')
    b[i,j]=coef

   endif

   i=i+1 

  endo

  j=j+1

 endo

 b=dy.*b                                         ; Regressionsmatrix anpassen
 j=1

 vsk=0
 vsv=0
 while (j <= h)
  i=1

  vglue=matrix(1,m)+1
  while (i <= h)                                 ; Pfadkoeffizienten anfuegen

   if (d[j,i]==1)
    vglue=vglue | t[i,(2:(m+1))]

   endif

   if (dl[j,i]==1)
    vglue=vglue | t[i,(1:m)]

   endif

   i=i+1 

  endo

  if (rows(vglue) != 1)
   vglue=vglue[(2:rows(vglue)),]
   x=vglue'
   y=t[j,2:(m+1)]'
   coef=gls(x,y)
   yh=x*coef
   u=y-yh
   n=dim(y)
   p=dim(x)
   p=p[2,]
   squ=(y-yh)'*(y-yh)/(n-p)
   su=sqrt(squ)
   cb=squ*inv(x'*x)
   sb=xdiag(sqrt(cb))
   vsk=vsk | coef
   vsv=vsv | sb
  endif
  j=j+1
 endo
 vsk=vsk[2:rows(vsk)]
 vsk=vsk[,2:(h+1)]'
 vsv=vsv[2:rows(vsv)]
 vsv=vsv[,2:(h+1)]'

 vsk=floor(vsk*(10^genau))/(10^genau)           ; auf Genauigkeit abschneiden
 vsv=floor(vsv*(10^genau))/(10^genau)           ; auf Genauigkeit abschneiden
 sk=matrix(h,h)*0
 skl=matrix(h,h)*0
 sdv=matrix(h,h)*0
 slv=matrix(h,h)*0
 vsk=vsk'
 vsv=vsv'
 j=1
 while (j <= h)                                 
  i=1

  while (i <= h)                                 ; Ausgabeparameter vorbereiten
   if (d[j,i]==1)
    sk[j,i]=vsk[1]
    sdv[j,i]=vsv[1]
    dim(vsk)
    if (dim(vsk)>1)
     vsk=vsk[2:(dim(vsk))]
     vsv=vsv[2:(dim(vsv))]
    endif
   endif

   if (dl[j,i]==1)
    skl[j,i]=vsk[1]
    slv[j,i]=vsv[1]
    if (dim(vsk)>1)
     vsk=vsk[2:(dim(vsk))]
     slv=vsk[2:(dim(vsk))]
    endif
   endif

   i=i+1 

  endo

  j=j+1
 endo
 wg=w
 iter=iter-1
 lk=t'
;---------------------- Ende DPLS ----------------------------------------

endp