proc(values,vectors)=eigensm(x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      eigsm sort
; -----------------------------------------------------------------
;   Macro        eigensm
; -----------------------------------------------------------------
;   Description  Computes the eigenvalues and eigenvectors
;                of symmetric matrices and sorts by the 
;                eigenvalues in descending order. 
; -----------------------------------------------------------------
;   Keywords     eigen values, eigen vectors, linear algebra, matrix
; -----------------------------------------------------------------
;   Usage        y = eigensm (x) 
;   Input
;     Parameter  x  
;     Definition        array, p x p x d1 x d2 x ... x dn,
;                       symmetric in each layer.
;   Output
;     Parameter  y.values
;     Definition        array, p x 1 x d1 x d2 x ... x dn, 
;                       the eigenvalues.
;     Parameter  y.vectors
;     Definition        array, p x p x d1 x d2 x ... x dn, 
;                       the normalized eigenvectors.
; -----------------------------------------------------------------
;   Notes   x must be a symmetric matrix or an array of
;           symmetric matrices. eigensm does not check 
;           whether it is symmetric or not. 
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x=#(1,3)~#(3,1) 
;             {values,vectors}=eigensm(x) 
; -----------------------------------------------------------------
;   Result    Contents of values
;	      [1,]     4
;             [2,]    -2 
;             Contents of vectors
;             [1,] 0.70711  0.70711 
;             [2,] 0.70711 -0.70711
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 971110
; -----------------------------------------------------------------
;
  {values,vectors}=eigsm(x)
  tmp=sort(values~vectors',-1)    ; sort by eigenvalues
  values=tmp[,1]
  vectors=tmp[,2:rows(vectors)+1]'
endp


