proc(mux,hatbeta,beta0,hatsigmax,hatsigmae)=eivvec1(w,y,sigue,siguu)
; -----------------------------------------------------------------
;    Library	eiv
; -----------------------------------------------------------------
;    See_also   eivvec2
; -----------------------------------------------------------------
;    Macro	eivvec1
; -----------------------------------------------------------------
;    Description    eivvect1 presents the maximum likelihood estimators of the
;		    parameters in the measurement error models,
;		    which has more than one variable x. The covariances
;		    between e and u, Sigeu and the covariance matrix of
;		    u, siguu are known. All of the variables obey normal
;		    distributions. All parameters are estimated by
;		    maximum likelihood method in measurement error models.
; ----------------------------------------------------------------------------
;   Reference	 Fuller W. A. "Measurement Error Models", Wiley and
;		           Sons 1987, section 2.2.
; -----------------------------------------------------------------
;    Link         ../tutorials/eivstart.html Tutorial: EIV in XploRe 
; -----------------------------------------------------------------
;    Usage    {mux,hatbeta,beta0,hatsigmae,hatsigmax)=eivvec1(w,y,sigue,siguu)
;    Input
;      Parameter  w
;      Definition   n x p matrix, the design variables
;      Parameter  y
;      Definition   n x 1 matrix, the response
;      Parameter  sigue
;      Definition   p x 1 matrix, the  vector of covariances between
;		    u and e
;      Parameter  siguu
;      Definition   p x p matrix, the covariance matrix of U
;    Output
;      Parameter  mux
;      Definition   scalar, the mean value of x
;      Parameter  hatbeta1
;      Definition   vector, the estimate
;      Parameter hatbeta0
;      Definition  scalar, the estimate
;      Parameter hatsigmax
;      Definition  p x p matrix, the estimate of the covariance matrix of x
;      Parameter hatsigmae
;      Definition  scalar, the estimate of the variance of error e
; -----------------------------------------------------------------
;  Example library("xplore")
;	   library("eiv")
;	   n = 100
;	   randomize(n)
;	   nu =#(2,3,4)
;	   sig=0*matrix(3,3)
;	   sig[,1]=#(0.25, 0.9, 0.1)
;	   sig[,2]=#(0.9, 1, 0.2)
;	   sig[,3]=#(0.1, 0.2, 4)
;	   x=normal(n,3)*sig+nu'
;	   w=x+0.01*normal(n,3)
;	   a1=#(1.2, 1.3, 1.4)
;	   y=0.75+x*a1+0.09*normal(n)
;	   sigue=#(0.11, 0.09, 045)
;	   siguu=0*matrix(3,3)
;	   siguu[,1]=#(1.25, 0.009, 0.01)
;	   siguu[,2]=#(0.009,0.081, 0.02)
;	   siguu[,3]=#(0.01, 0.02, 1.96)
;          gest=eivvec1(w,y,sigue,siguu)
;	   gest.mux
;	   gest.hatbeta
;	   gest.beta0
;	   gest.hatsigmax
;	   gest.hatsigmae
; -----------------------------------------------------------------
; Result  Contents of mux
;         [1,]    2.024   2.9106   3.9382 
;         Contents of hatbeta
;         [1,]   0.011384  
;         [2,]   0.013461 
;         [3,]   0.013913
;         Contents of beta0
;         [1,]   12.362  
;         Contents of hatsigmax
;         [1,]  0.84466   1.0319  0.43677 
;         [2,]   1.0319    1.664   1.0941 
;         [3,]  0.43677   1.0941   19.781 
;         Contents of hatsigmae
;         [1,]   1034.9 
; -----------------------------------------------------------------
;   Author    Hua Liang,  970725
; --------------------------------------------------------
library("xplore")
     mux=mean(w)
     mww=cov(w)
     mwy=mean((w-mean(w)).*(y-mean(y)))/(rows(w)-1)
     myy=var(y)
     beta1=inv(mww-siguu)*(mwy'-sigue)
     beta0=mean(y)-mean(w)*beta1
     sigmae=myy-2*mwy*beta1+beta1'*mww*beta1+2*sigue'*beta1-beta1'*siguu*beta1
     sigmax=mww-siguu
     z=y~w
     n=rows(w)
     mzz=(z'*z)/n
     p=cols(w)
     sigmaa11=sigue'*inv(siguu)*sigue
     Sigmaa=0*matrix(p+1,p+1)
     Sigmaa[1,1]=sigmaa11
     Sigmaa[2:p+1,1]=sigue
     Sigmaa[1,2:p+1]=sigue'
     Sigmaa[2:p+1,2:p+1]=siguu
     {lam,veclam}=eigsm(Sigmaa*inv(mzz))
     lam=sort(lam,1)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    {e1,e2}=eigsm(sigmax)
     e1=sort(e1,1)
   if((e1[1]>0)&&(sigmae>=sigmaa11))
      hatbeta=beta1
      hatsigmax=sigmax
      hatsigmae=sigmae
   else
     if(((lam[p+1]>1)&&(lam[p]<1)))
        lamp=inv(lam[p+1])
        hatbeta=inv(mww-lamp*siguu)*(mwy'-lamp*sigue)
        hatsigmae=sigmaa11
        hatsigmax=mww-lamp*siguu
      else
        hatbeta="indetermine"
      endif
   endif
     beta0=mean(y)-mean(w)*hatbeta
endp
