proc (r) = empme (x, t)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      gpme gp1me
; -----------------------------------------------------------------
;   Macro         empme
; -----------------------------------------------------------------
;   Description   empme evalatues the empirical mean excess function
;                 of the data set x at the points t
; -----------------------------------------------------------------
;   Usage         r = empme (x, t)
;   Input
;     Parameter   x
;     Definition      vector, data set
;     Parameter   t
;     Definition      vector
;   Output
;     Parameter   r
;     Definition      vector
; -----------------------------------------------------------------
;   Example   library("finance")
;	            x=sort(randx("gp",100,1))
;	            r=empme(x,x[1:99])
;             r
; -----------------------------------------------------------------
;   Result    vector with empirical mean excess function
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  y = paf (x, x > t [1])
  if (rows (y) > 0)
    r = mean (y - t [1])
  else
    r = 0
  endif
  if (rows (t) > 1)
    r = #(r)
    j = 2
    while (j <= rows (t))
      y = paf (x, x > t [j])
      if (rows (y) > 0)
          r = r | mean (y - t [j])
      endif
      j = j + 1
    endo
  endif
endp