proc(rotm,tourparam)=eppet(tourparamin, x)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        eppet
; -----------------------------------------------------------------------
; Description  Optimizes the Entropy index.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971113
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.eet<0.01)
    tourparam.eet = 1    
  endif
  p = rows(tourparam.eetrot)
  tourparam.eet = tourparam.eet* (1-tourparam.eetdt)
  rotm = orthonormal(tourparam.eetrot + tourparam.eet.*normal(p,p))
  px   = x*rotm[,1:2]
  h    = tourparam.eeth.*matrix(1,2)
  ind  = indexentropy (px, h)
  if (ind>tourparam.eetind)
    tourparam.eetind = ind
    tourparam.eetrot = rotm
  else
    rotm = tourparam.eetrot
  endif
endp
