proc(rotm,tourparam)=eppher(tourparamin, x)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        eppher
; -----------------------------------------------------------------------
; Description  Optimizes the Hermite index
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971113
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.ehert<0.01)
    tourparam.ehert = 1    
  endif
  p = rows(tourparam.eherrot)
  tourparam.ehert = tourparam.ehert * (1-tourparam.eherdt)
  rotm = orthonormal(tourparam.eherrot + tourparam.ehert.*normal(p,p))
  px   = x*rotm[,1:2]
  h    = tourparam.eherh.*matrix(1,2)
  ind  = indexhermite(px, h)
  if (ind>tourparam.eherind)
    tourparam.eherind = ind
    tourparam.eherrot = rotm
  else
    rotm = tourparam.eherrot
  endif
endp
