proc (e) = excess (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      skewness kurtosis
; -----------------------------------------------------------------
;  Keywords      moments, kurtosis, excess
; -----------------------------------------------------------------
;   Macro        excess
; -----------------------------------------------------------------
;   Description  Computes the excess (kurtosis-3) for a given vector.
; -----------------------------------------------------------------
;   Usage        e = excess (x)
;   Input
;     Parameter  x  
;     Definition    vector
;   Output
;     Parameter  e
;     Definition    scalar
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (100)
;             excess (x)
; -----------------------------------------------------------------
;   Result    Contents of e
;             [1,]   0.27942
; -----------------------------------------------------------------
;   Author    TTK, 960207; Marlene Mueller 990308
; -----------------------------------------------------------------
  e  = mean ((x-mean(x))^4) ./ (var(x)^2) - 3
endp

