proc (m) = factorial (n)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      cumprod
; -----------------------------------------------------------------
;  Keywords      factorial
; -----------------------------------------------------------------
;   Macro        factorial
; -----------------------------------------------------------------
;   Description  Computes the factorial for all values
;                in an array.
; -----------------------------------------------------------------
;   Usage        m = factorial (n)
;   Input
;     Parameter  n
;     Definition array
;   Output
;     Parameter  m
;     Definition array  containing the factorials
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = 3*normal (2, 3) ~ (0|0)
;             factorial (x)
; -----------------------------------------------------------------
;   Result   Contents of m
;            [1,]       1      120       24        1
;            [2,]       6        6        2        1
; -----------------------------------------------------------------
;   Notes    The factorial is computed for the absolute
;            integer values of n.
; -----------------------------------------------------------------
;   Author    TTK, 970617
; -----------------------------------------------------------------
  d = dim (n)                              // to restore dimensions
  n = #(abs (n))                           // only positive values
  n = n + (n<1)                            // treat 0 like 1
  m = reshape (cumprod (1:max (n))[n], d)  // that's all
endp
