proc(f)=fgenci(di,ord);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  
; ----------------------------------------------------------------------
;   Macro	  fgenci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         f =fgenci(di,ord)
;   Input 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   ord 
;     Definition     integer, order of series 
;   Output
;     Parameter   f
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
  d=di*ord+1;
  f=eye(d);
  if (ord>1); 
    f[2:d-di,2+di:d]=-eye(d-di-1);
  endif;
  f=diagrv(f,ones(d,1));
endp;
