proc(a,b)=floatinf(x)
; -----------------------------------------------------------------
;   Library   multi   
; -----------------------------------------------------------------
;   See_also  rint   
; -----------------------------------------------------------------
;   Macro     floatinf     
; -----------------------------------------------------------------
;   Description  provides information about real numbers
;                within the interval [.5,0) in the form of
;                x=a*10^b, b is bounded by -20
; -----------------------------------------------------------------
;   Usage        {a,b} = floatinf(x)     
;   Input
;     Parameter  x   
;     Definition  (1x1) real value               
;   Output                                                           
;     Parameter  a   
;     Definition  (1x1) real value, element of the interval [+inf,.5) 
;     Parameter   b
;     Definition   (1x1) integer, power of 10
; -----------------------------------------------------------------
;   Example    library("multi")
;              {a,b}=floatinf(.00123)
;              a
;              b 
; -----------------------------------------------------------------
;   Result     Contents of a
;              [1,]     1.23
;              Contents of b
;              [1,]       -3 
; -----------------------------------------------------------------
;   Example    library("multi")
;              {a,b}=floatinf(1.23*10^(-23))
;              a
;              b 
; -----------------------------------------------------------------
;   Result     Contents of a
;              [1,]     0.0123
;              Contents of b
;              [1,]        -21 
; -----------------------------------------------------------------
;   Author Benkwitz 980125 
; -----------------------------------------------------------------
a=x
i=0
while ((rint(a)==0)&&(i<21))
  i=i+1
  a=x*10^i
endo  
b=-i
endp
