proc(covci)=fncovci(f,covu,om,c,di,ord,rk);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  fncovci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         covci =fncovci(f,covu,om,c,di,ord,rk)
;   Input 
;     Parameter   f 
;     Definition     matrix, 
;     Parameter   covu 
;     Definition     matrix, covariance
;     Parameter   om 
;     Definition     matrix, 
;     Parameter   c 
;     Definition     vector, 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   rk 
;     Definition     integer, rank of matrix (dimension-cointegration rank)
;   Output
;     Parameter   covci
;     Definition     matrix, covariance matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
  s=di*ord+1-di;
  x=(eye(s)~zeros(s,rk))|(zeros(di,s)~c');
  covci=kron(f' * x * inv(om) * x' * f, covu)
endp;
