proc()=gamout(t,y,m,b,const,opt)
; ----------------------------------------------------------------------------
;   Library      gam
; ----------------------------------------------------------------------------
;   See_also     gamfit, gamopt,gintest
; ----------------------------------------------------------------------------
;   Macro        gamout
; ----------------------------------------------------------------------------
;   Description  creates a nice output for GAM. ! auxiliary macro !
; ----------------------------------------------------------------------------
;   Link         ../tutorials/gamstart.html Tutorial: GAM in XploRe
; ----------------------------------------------------------------------------
;   Usage         gamout(t,y,m,b,const{,opt})
;   Input
;     Parameter   t
;     Definition        n x p  matrix, the predictor variables.
;     Parameter   y
;     Definition        n x 1  vector, the response variables.
;     Parameter   m
;     Definition        n x dd  matrix, estimated functions.
;     Parameter   b
;     Definition        p x 1, estimated coefficients.
;     Parameter   const
;     Definition        scalar, the estimated constant.
;     Parameter   opt
;     Definition        optional list, a list with optional input. The macro
;                       "gamopt" can be used to set up this parameter.
;                       The order of the list elements is not important.
;                       Parameters which are not given are replaced by
;                       defaults. For details see gamopt.
; ----------------------------------------------------------------------------
;   Example   library("gam")
;             n=100
;             b=1|2
;             p=rows(b)
;             x=2.*uniform(n,p)-1
;             t=2.*uniform(n,1)-1
;             y=x*b+t^3+normal(n)./2
;             opt=gamopt("x",x,"pl",1)
;             {m,b,const}=backfit(t,y,1,0,"qua",opt)
;             gamout(t,y,m,b,const,opt)
; ----------------------------------------------------------------------------
;   Result    Display(s) with estimated functions, data points and more
; ----------------------------------------------------------------------------
;   Author    Stockmeyer, Mueller, 971023
; ----------------------------------------------------------------------------
;
  name = "gampic"
  n = rows(t)
  p = cols(t)
;
; control parameters
; ----------------------------------------------------------------------------
  nopic = 0
  if (comp("opt","nopic")>0)
    nopic = opt.nopic
  endif
  if (comp("opt","tg")>0)
    xpic = opt.tg
    nod = cols(xpic)
    havegrid = 1
  else
    havegrid = 0
    nod = p
    xpic = t
  endif
  if (comp("opt","loc")>0)
    loc = opt.loc
  else
    loc = 0
  endif
  havedis = 0
  if (comp("opt","pl")>0)
    if ((opt.pl)&&(comp("opt","x")>0))
      havedis = 1
      x = opt.x
      if (comp("opt","xvars")>0)
        xvars = opt.xvars
      else
        xvars = string("x%1.0f",(1:cols(x)))
      endif
    endif
  endif
  if (comp("opt","descript")>0)
    descript = opt.descript
  else
    descript = 0
  endif
  if (comp("opt","tvars")>0)
    tvars = opt.tvars
  else
    tvars = string("t%1.0f",1:cols(t))
  endif
  if (comp("opt","yvars")>0)
    yvars = opt.yvars
  else
    yvars = "y"
  endif
  if (comp("opt","bv")>0)
    havebv = 1
    bv = opt.bv
  else
    havebv = 0
  endif
;
; create display
; ----------------------------------------------------------------------------
  if (nopic!=1)
    if (comp("opt","name")>0)
      name = opt.name
    endif
    nof = loc + 1
    nop = nod * nof
    exec(name+"=createdisplay(nof,nod)")
    dir = 1
    while (dir<=nod)
      fct = 1
      while (fct<=nof)
        pos = (fct-1)*nod+dir
        data = xpic[,dir]~m[,pos]
        link = sort(data[,1]~(1:rows(data)))[,2]
        setmaskp(data,4,3,6)
        setmaskl(data,link',4,1,1)
        exec("show("+name+",fct,dir,data)")
;hier noch einbauen y mit namen!!
        xlabel = "xlabel"
        title = "title"
        switch
        case ((comp("opt","title")>0)&&(comp("opt","tvars")>0))
          exec("setgopt("+name+",fct,dir,xlabel,opt.tvars[dir],title,opt.title[pos])")
          break
        case (comp("opt","tvars")>0)
          exec("setgopt("+name+",fct,dir,xlabel,opt.tvars[dir])")
          break
        case (comp("opt","title")>0)
          exec("setgopt("+name+",fct,dir,title,opt.title[pos])")
          break
        endsw
        fct = fct + 1
      endo
      dir = dir + 1
    endo
  endif
  if ((havedis)&&(nopic!=1))
    coefficients = createdisplay(1,1)
    j = 1
    text = " "|"Coefficients for discrete variables"
    text = text|"___________________________________"|"  "
    line1 = "                  coefficient"
    line2 = "       ----------------------"
    if (havebv)
      line1 = line1+"  std.deviation"
      line2 = line2+"---------------"
    endif
    text = text|line1|line2
    while (j<=rows(b))
      line = substr(xvars[j]+"               ",1,16)
      line = line+string("%14.5g",b[j])
      if (havebv)
        line = line+string(" %14.5g",sqrt(bv[j,j]))
      endif
      text = text|line
      j = j + 1
    endo
    text = text|string("Constant       %14.5g",const)
    show(coefficients,1,1,text)
  endif
  if (descript)
    description = createdisplay(1,1)
    desc = " "|"Descriptive Statistics"
    desc = desc|"______________________"|" "
    txt = "n="+string("%1.0f",rows(y))
    txt = txt+", "+string("%1.0f",cols(t))+" continuous variables"
    v = y~t
    vars = yvars|tvars
    if (havedis)
      txt = txt+", "+string("%1.0f",cols(opt.x))+" discrete variables"
      v = v~opt.x
      vars = vars|xvars
    endif
    desc = desc|txt|" "
    desc = desc|summarize(v,vars)
    show(description,1,1,desc)
  endif
endp
