proc(y,s2) = genarch(a,b,n)
; -----------------------------------------------------------------
; Library	times
; -----------------------------------------------------------------
;  See_also	genarma
; -----------------------------------------------------------------
;   Macro 	genarch
; -----------------------------------------------------------------
;   Description	generates a GARCH process with Gaussian innovations
; -----------------------------------------------------------------
;   Usage	y = genarch(a, b, n)
;   Input 
;     Parameter   a
;     Definition  (q+1)-vector of constant and ARCH parameters
;     Parameter   b
;     Definition  p-vector of GARCH parameters
;     Parameter   n
;     Definition  scalar, length of output process
;   Output
;     Parameter   y
;     Definition  n-vector, the GARCH process
;     Parameter   s2
;     Definition  n-vector, the volatility process
; ------------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 y = genarch(0.1|0.2,0.7,5)
;                 y{1}
; ------------------------------------------------------------------
;   Result        Contents of y  
;                 [1,]  0.87293 
;                 [2,] -0.81784 
;                 [3,]  -1.0228 
;                 [4,]  0.56941 
;                 [5,] -0.30926  
; ------------------------------------------------------------------
;   Author        Christian Hafner, 960819
; ------------------------------------------------------------------
  q = rows(a)-1	; order of ARCH without constant
  error(q<1, "a must contain at least 2 elements")
  error(sum(a[2:q+1])+sum(b)>=1, "Process is nonstationary!")
  errtxt="Parameters must be nonnegative!"
  error(((sum(a<0))||(sum(b<0)))>=1, errtxt)
  p = rows(b)	; order of GARCH
  m = p+q	
  y = matrix(n+m)
    ; initialize conditional variance at unconditional variance
  s2 = (a[1]/(sum(a[2:q+1])+sum(b))).*matrix(n+m) 
    ; starting values
  y[1:m] = sqrt(s2[1:m]).*normal(m)		 
  i = m+1
  while (i<=n+m)
    s2[i] = a[1] + a[2:q+1]'*y[i-1:i-q]^2+b'*s2[i-1:i-p]
    y[i] = sqrt(s2[i])*normal(1)
    i = i+1
  endo
  y = y[m+1:m+n]
  s2 = s2[m+1:m+n]
endp
